/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ClientHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class WiretapConnector
implements ClientHttpConnector {
    private final ClientHttpConnector delegate;
    private final Map<String, Info> exchanges = new ConcurrentHashMap<String, Info>();

    WiretapConnector(ClientHttpConnector delegate) {
        this.delegate = delegate;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference requestRef = new AtomicReference();
        return this.delegate.connect(method, uri, request -> {
            WiretapClientHttpRequest wrapped = new WiretapClientHttpRequest((ClientHttpRequest)request);
            requestRef.set(wrapped);
            return (Mono)requestCallback.apply((ClientHttpRequest)wrapped);
        }).map(response -> {
            WiretapClientHttpRequest wrappedRequest = (WiretapClientHttpRequest)((Object)((Object)requestRef.get()));
            String header = "WebTestClient-Request-Id";
            String requestId = wrappedRequest.getHeaders().getFirst(header);
            Assert.state((requestId != null ? 1 : 0) != 0, () -> "No \"" + header + "\" header");
            WiretapClientHttpResponse wrappedResponse = new WiretapClientHttpResponse((ClientHttpResponse)response);
            this.exchanges.put(requestId, new Info(wrappedRequest, wrappedResponse));
            return wrappedResponse;
        });
    }

    public Info claimRequest(String requestId) {
        Info info = this.exchanges.remove(requestId);
        Assert.state((info != null ? 1 : 0) != 0, () -> {
            String header = "WebTestClient-Request-Id";
            return "No match for " + header + "=" + requestId;
        });
        return info;
    }

    private static class WiretapClientHttpResponse
    extends ClientHttpResponseDecorator {
        private final WiretapRecorder recorder = new WiretapRecorder((Publisher<? extends DataBuffer>)super.getBody(), null);

        public WiretapClientHttpResponse(ClientHttpResponse delegate) {
            super(delegate);
        }

        public WiretapRecorder getRecorder() {
            return this.recorder;
        }

        public Flux<DataBuffer> getBody() {
            return Flux.from(this.recorder.getPublisherToUse());
        }
    }

    private static class WiretapClientHttpRequest
    extends ClientHttpRequestDecorator {
        @Nullable
        private WiretapRecorder recorder;

        public WiretapClientHttpRequest(ClientHttpRequest delegate) {
            super(delegate);
        }

        public WiretapRecorder getRecorder() {
            Assert.notNull((Object)this.recorder, (String)"No WiretapRecorder: was the client request written?");
            return this.recorder;
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> publisher) {
            this.recorder = new WiretapRecorder(publisher, null);
            return super.writeWith(this.recorder.getPublisherToUse());
        }

        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
            this.recorder = new WiretapRecorder(null, publisher);
            return super.writeAndFlushWith(this.recorder.getNestedPublisherToUse());
        }

        public Mono<Void> setComplete() {
            this.recorder = new WiretapRecorder(null, null);
            return super.setComplete();
        }
    }

    static final class WiretapRecorder {
        private static final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
        @Nullable
        private final Flux<? extends DataBuffer> publisher;
        @Nullable
        private final Flux<? extends Publisher<? extends DataBuffer>> publisherNested;
        private final DataBuffer buffer = bufferFactory.allocateBuffer();
        private final MonoProcessor<byte[]> content = MonoProcessor.create();
        private boolean hasContentConsumer;

        public WiretapRecorder(@Nullable Publisher<? extends DataBuffer> publisher, @Nullable Publisher<? extends Publisher<? extends DataBuffer>> publisherNested) {
            if (publisher != null && publisherNested != null) {
                throw new IllegalArgumentException("At most one publisher expected");
            }
            this.publisher = publisher != null ? Flux.from(publisher).doOnSubscribe(s -> {
                this.hasContentConsumer = true;
            }).doOnNext(xva$0 -> this.buffer.write(new DataBuffer[]{xva$0})).doOnError(this::handleOnError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete) : null;
            Flux<? extends Publisher<? extends DataBuffer>> flux = this.publisherNested = publisherNested != null ? Flux.from(publisherNested).doOnSubscribe(s -> {
                this.hasContentConsumer = true;
            }).map(p -> Flux.from((Publisher)p).doOnNext(xva$0 -> this.buffer.write(new DataBuffer[]{xva$0})).doOnError(this::handleOnError)).doOnError(this::handleOnError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete) : null;
            if (publisher == null && publisherNested == null) {
                this.content.onComplete();
            }
        }

        public Publisher<? extends DataBuffer> getPublisherToUse() {
            Assert.notNull(this.publisher, (String)"Publisher not in use.");
            return this.publisher;
        }

        public Publisher<? extends Publisher<? extends DataBuffer>> getNestedPublisherToUse() {
            Assert.notNull(this.publisherNested, (String)"Nested publisher not in use.");
            return this.publisherNested;
        }

        public Mono<byte[]> getContent() {
            return Mono.defer(() -> {
                if (this.content.isTerminated()) {
                    return this.content;
                }
                if (!this.hasContentConsumer) {
                    (this.publisher != null ? this.publisher : this.publisherNested).onErrorMap(ex -> new IllegalStateException("Content was not been consumed and an error was raised on attempt to produce it:", (Throwable)ex)).subscribe();
                }
                return this.content;
            });
        }

        private void handleOnError(Throwable ex) {
            if (!this.content.isTerminated()) {
                this.content.onError(ex);
            }
        }

        private void handleOnComplete() {
            if (!this.content.isTerminated()) {
                byte[] bytes = new byte[this.buffer.readableByteCount()];
                this.buffer.read(bytes);
                this.content.onNext((Object)bytes);
            }
        }
    }

    class Info {
        private final WiretapClientHttpRequest request;
        private final WiretapClientHttpResponse response;

        public Info(WiretapClientHttpRequest request, WiretapClientHttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public ExchangeResult createExchangeResult(Duration timeout, @Nullable String uriTemplate) {
            return new ExchangeResult((ClientHttpRequest)this.request, (ClientHttpResponse)this.response, this.request.getRecorder().getContent(), this.response.getRecorder().getContent(), timeout, uriTemplate);
        }
    }
}

