/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import jakarta.websocket.Session;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.tomcat.websocket.WsSession;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketSession;
import reactor.core.publisher.Sinks;

public class TomcatWebSocketSession
extends StandardWebSocketSession {
    private static final AtomicIntegerFieldUpdater<TomcatWebSocketSession> SUSPENDED = AtomicIntegerFieldUpdater.newUpdater(TomcatWebSocketSession.class, "suspended");
    private volatile int suspended;

    public TomcatWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        super(session, info, factory);
    }

    public TomcatWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, Sinks.Empty<Void> completionSink) {
        super(session, info, factory, completionSink);
        this.suspendReceiving();
    }

    @Override
    protected boolean canSuspendReceiving() {
        return true;
    }

    @Override
    protected void suspendReceiving() {
        if (SUSPENDED.compareAndSet(this, 0, 1)) {
            ((WsSession)this.getDelegate()).suspend();
        }
    }

    @Override
    protected void resumeReceiving() {
        if (SUSPENDED.compareAndSet(this, 1, 0)) {
            ((WsSession)this.getDelegate()).resume();
        }
    }
}

