/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.test.client.ErrorResponseCreator;
import org.springframework.ws.test.client.RequestMatcher;
import org.springframework.ws.test.client.ResponseActions;
import org.springframework.ws.test.client.ResponseCreator;
import org.springframework.ws.transport.WebServiceConnection;

class MockSenderConnection
implements WebServiceConnection,
ResponseActions {
    private final List<RequestMatcher> requestMatchers = new LinkedList<RequestMatcher>();
    private URI uri;
    private WebServiceMessage request;
    private ResponseCreator responseCreator;

    MockSenderConnection() {
    }

    void addRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"'requestMatcher' must not be null");
        this.requestMatchers.add(requestMatcher);
    }

    void setUri(URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        this.uri = uri;
    }

    @Override
    public ResponseActions andExpect(RequestMatcher requestMatcher) {
        this.addRequestMatcher(requestMatcher);
        return this;
    }

    @Override
    public void andRespond(ResponseCreator responseCreator) {
        Assert.notNull((Object)responseCreator, (String)"'responseCreator' must not be null");
        this.responseCreator = responseCreator;
    }

    public void send(WebServiceMessage message) throws IOException {
        if (!this.requestMatchers.isEmpty()) {
            for (RequestMatcher requestMatcher : this.requestMatchers) {
                requestMatcher.match(this.uri, message);
            }
        } else {
            throw new AssertionError((Object)("Unexpected send() for [" + String.valueOf(message) + "]"));
        }
        this.request = message;
    }

    public WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        if (this.responseCreator != null) {
            return this.responseCreator.createResponse(this.uri, this.request, messageFactory);
        }
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean hasError() throws IOException {
        return this.responseCreator instanceof ErrorResponseCreator;
    }

    public String getErrorMessage() throws IOException {
        if (this.responseCreator instanceof ErrorResponseCreator) {
            return ((ErrorResponseCreator)this.responseCreator).getErrorMessage();
        }
        return null;
    }

    public void close() throws IOException {
        this.requestMatchers.clear();
        this.request = null;
        this.responseCreator = null;
        this.uri = null;
    }
}

