/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.FluentStyle;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class FluentBeanWrapper
extends AbstractPropertyAccessor
implements BeanFactoryAware {
    private Object target;
    private final FluentStyle fluentStyle;
    private final String fluentMethodPrefix;
    private final String buildMethod;
    private final ListMultimap<String, Method> properties = ArrayListMultimap.create();
    private final TypeConverterDelegate typeConverterDelegate;
    private BeanFactory beanFactory;

    public FluentBeanWrapper(Object target, String fluentMethodPrefix, String buildMethod, FluentStyle fluentStyle) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.notNull((Object)fluentMethodPrefix, (String)"Fluent method prefix must not be null");
        Assert.notNull((Object)buildMethod, (String)"Build method must not be null");
        Assert.notNull((Object)((Object)fluentStyle), (String)"Fluent style must not be null");
        this.target = target;
        this.fluentStyle = fluentStyle;
        this.fluentMethodPrefix = fluentMethodPrefix;
        this.buildMethod = buildMethod;
        this.typeConverterDelegate = new TypeConverterDelegate((PropertyEditorRegistrySupport)this, target);
        this.registerDefaultEditors();
        if (fluentStyle == FluentStyle.PROPERTIES) {
            this.registerFluentProperties(fluentMethodPrefix);
        } else {
            this.registerFluentMethods();
        }
    }

    private void registerFluentMethods() {
        ReflectionUtils.doWithMethods(this.target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                FluentBeanWrapper.this.properties.put((Object)method.getName(), (Object)method);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.getParameterTypes().length == 1 && FluentBeanWrapper.this.target.getClass().isAssignableFrom(method.getReturnType());
            }
        });
    }

    private void registerFluentProperties(final String fluentMethodPrefix) {
        ReflectionUtils.doWithMethods(this.target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String propertyName = method.getName().substring(fluentMethodPrefix.length());
                FluentBeanWrapper.this.properties.put((Object)StringUtils.uncapitalize((String)propertyName), (Object)method);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.getName().startsWith(fluentMethodPrefix) && method.getParameterTypes().length == 1 && FluentBeanWrapper.this.target.getClass().isAssignableFrom(method.getReturnType());
            }
        });
    }

    public boolean isReadableProperty(String propertyName) throws BeansException {
        return false;
    }

    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.properties.containsKey((Object)propertyName);
    }

    public Class<?> getPropertyType(String propertyName) throws BeansException {
        return null;
    }

    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        return null;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        throw new InvalidPropertyException(this.target.getClass(), propertyName, "Property is not accessible");
    }

    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        this.setPropertyValue(propertyName, newValue, null);
    }

    public void setPropertyValue(String propertyName, Object newValue, Class<?> type) throws BeansException {
        Method method = this.getFluentMethod(propertyName, type);
        if (method == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Property '" + propertyName + "' does not exist");
        }
        Class<?> paramType = method.getParameterTypes()[0];
        if (newValue instanceof RuntimeBeanReference) {
            String beanName = ((RuntimeBeanReference)newValue).getBeanName();
            newValue = this.beanFactory.getBean(beanName);
        }
        try {
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(propertyName, null, newValue, paramType, new TypeDescriptor(new MethodParameter(method, 0)));
            this.target = method.invoke(this.target, convertedValue);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, null, newValue);
            throw new ConversionNotSupportedException(pce, paramType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, null, newValue);
            throw new TypeMismatchException(pce, paramType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, null, newValue);
            throw new TypeMismatchException(pce, paramType, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Property is not accessible", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Fluent method threw an exception", (Throwable)ex);
        }
    }

    public Object build() throws Exception {
        return BeanUtils.findMethod(this.target.getClass(), (String)this.buildMethod, (Class[])new Class[0]).invoke(this.target, new Object[0]);
    }

    private Method getFluentMethod(String propertyName, Class<?> type) {
        List methods = this.properties.get((Object)propertyName);
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        String methodName = this.fluentStyle == FluentStyle.METHODS ? propertyName : this.fluentMethodPrefix + StringUtils.capitalize((String)propertyName);
        return MethodUtils.getMatchingAccessibleMethod(this.target.getClass(), (String)methodName, (Class[])new Class[]{type});
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return (T)this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

