/*
 * Decompiled with CFR 0.152.
 */
package org.stuartgunter.spring.beans.factory.xml;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FluentBeanWrapper;
import org.springframework.beans.FluentStyle;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class BuilderFactoryBean
extends AbstractFactoryBean {
    private Class<?> builderClass;
    private String buildMethod;
    private String methodPrefix;
    private FluentStyle fluentStyle;
    private Map<String, List<Object>> builderProperties;

    public void setBuilderClass(Class<?> builderClass) {
        this.builderClass = builderClass;
    }

    public void setBuildMethod(String buildMethod) {
        this.buildMethod = buildMethod;
    }

    public void setMethodPrefix(String methodPrefix) {
        this.methodPrefix = methodPrefix;
    }

    public void setFluentStyle(FluentStyle fluentStyle) {
        this.fluentStyle = fluentStyle;
    }

    public void setBuilderProperties(Map<String, List<Object>> builderProperties) {
        this.builderProperties = builderProperties;
    }

    public Class<?> getObjectType() {
        return this.findBuildMethodReturnType();
    }

    protected Object createInstance() throws Exception {
        Object builder = BeanUtils.instantiate(this.builderClass);
        FluentBeanWrapper fluentBeanWrapper = new FluentBeanWrapper(builder, this.methodPrefix, this.buildMethod, this.fluentStyle);
        fluentBeanWrapper.setBeanFactory(this.getBeanFactory());
        for (Map.Entry<String, List<Object>> builderProperty : this.builderProperties.entrySet()) {
            String propertyname = builderProperty.getKey();
            for (Object propertyValue : builderProperty.getValue()) {
                fluentBeanWrapper.setPropertyValue(propertyname, propertyValue);
            }
        }
        return fluentBeanWrapper.build();
    }

    private Class<?> findBuildMethodReturnType() {
        if (this.builderClass == null || this.buildMethod == null) {
            return null;
        }
        try {
            Method method = BeanUtils.findDeclaredMethod(this.builderClass, (String)this.buildMethod, null);
            return method == null ? null : method.getReturnType();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

