/*
 * Decompiled with CFR 0.152.
 */
package org.stuartgunter.spring.beans.factory.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.FluentStyle;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.stuartgunter.spring.beans.factory.xml.BuilderFactoryBean;
import org.w3c.dom.Element;

public class BuilderFactoryBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return BuilderFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.configureAttributeForBuilder("target-class", "targetClass", element, builder);
        this.configureAttributeForBuilder("fluent-style", "fluentStyle", (Object)FluentStyle.PROPERTIES, element, builder);
        this.configureAttributeForBuilder("builder-class", "builderClass", element, builder);
        this.configureAttributeForBuilder("method-prefix", "methodPrefix", "with", element, builder);
        this.configureAttributeForBuilder("build-method", "buildMethod", "build", element, builder);
        HashMap builderProperties = Maps.newHashMap();
        List properties = DomUtils.getChildElementsByTagName((Element)element, (String)"with");
        for (Element property : properties) {
            String name = property.getAttribute("name");
            List values = (List)builderProperties.get(name);
            if (values == null) {
                values = Lists.newArrayList();
                builderProperties.put(name, values);
            }
            values.add(this.createBuilderProperty(property, parserContext));
        }
        builder.addPropertyValue("builderProperties", (Object)builderProperties);
    }

    private Object createBuilderProperty(Element property, ParserContext parserContext) {
        if (property.hasAttribute("value") && property.hasAttribute("ref")) {
            parserContext.getReaderContext().fatal("A 'with' element may either have a 'value' or 'ref' attribute, but not both", (Object)property);
        }
        if (property.hasAttribute("value")) {
            return property.getAttribute("value");
        }
        return new RuntimeBeanReference(property.getAttribute("ref"));
    }

    private void configureAttributeForBuilder(String attributeName, String propertyName, Element element, BeanDefinitionBuilder builder) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(propertyName, (Object)attributeValue);
        }
    }

    private void configureAttributeForBuilder(String attributeName, String propertyName, Object defaultValue, Element element, BeanDefinitionBuilder builder) {
        String attributeValue = element.getAttribute(attributeName);
        Object value = StringUtils.hasText((String)attributeValue) ? attributeValue : defaultValue;
        builder.addPropertyValue(propertyName, value);
    }
}

