/*
 * Decompiled with CFR 0.152.
 */
package tachyon.shell;

import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;
import tachyon.client.block.TachyonBlockStore;
import tachyon.client.file.FileInStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.DeleteOptions;
import tachyon.client.file.options.FreeOptions;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.LoadMetadataOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.client.file.options.SetStateOptions;
import tachyon.client.lineage.TachyonLineage;
import tachyon.client.lineage.options.DeleteLineageOptions;
import tachyon.conf.TachyonConf;
import tachyon.exception.ExceptionMessage;
import tachyon.exception.TachyonException;
import tachyon.job.CommandLineJob;
import tachyon.job.Job;
import tachyon.job.JobConf;
import tachyon.shell.TfsShellUtils;
import tachyon.thrift.BlockLocation;
import tachyon.thrift.FileInfo;
import tachyon.thrift.LineageInfo;
import tachyon.util.FormatUtils;
import tachyon.util.io.PathUtils;

public class TfsShell
implements Closeable {
    private final Closer mCloser;
    private final TachyonConf mTachyonConf;
    private final TachyonFileSystem mTfs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        int ret;
        TfsShell shell = new TfsShell(new TachyonConf());
        try {
            ret = shell.run(argv);
        }
        finally {
            shell.close();
        }
        System.exit(ret);
    }

    public TfsShell(TachyonConf tachyonConf) {
        this.mTachyonConf = tachyonConf;
        this.mCloser = Closer.create();
        this.mTfs = TachyonFileSystem.TachyonFileSystemFactory.get();
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cat(TachyonURI path) throws IOException {
        FileInfo tFile;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            tFile = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (!tFile.isFolder) {
            FileInStream is;
            InStreamOptions op = new InStreamOptions.Builder(this.mTachyonConf).setTachyonStorageType(TachyonStorageType.NO_STORE).build();
            try {
                is = this.mTfs.getInStream(fd, op);
            }
            catch (TachyonException e) {
                System.out.print(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
                return -1;
            }
            byte[] buf = new byte[512];
            try {
                int read = is.read(buf);
                while (read != -1) {
                    System.out.write(buf, 0, read);
                    read = is.read(buf);
                }
            }
            finally {
                is.close();
            }
            return 0;
        }
        System.out.println(path + " is not a file.");
        return -1;
    }

    public int load(TachyonURI filePath) throws IOException {
        int ret = this.loadPath(this.mTfs, filePath);
        if (ret == 0) {
            System.out.println(filePath + " loaded");
        } else {
            System.out.println("Loading " + filePath + " failed");
        }
        return ret;
    }

    private int loadPath(TachyonFileSystem tachyonClient, TachyonURI filePath) throws IOException {
        int n;
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(filePath);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (IOException ioe) {
            return -1;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (fInfo.isFolder) {
            List files = tachyonClient.listStatus(fd);
            Collections.sort(files);
            for (FileInfo file : files) {
                TachyonURI newPath = new TachyonURI(file.getPath());
                if (this.loadPath(tachyonClient, newPath) != -1) continue;
                return -1;
            }
            return 0;
        }
        if (fInfo.getInMemoryPercentage() == 100) {
            return 0;
        }
        Closer closer = Closer.create();
        try {
            InStreamOptions op = new InStreamOptions.Builder(this.mTachyonConf).setTachyonStorageType(TachyonStorageType.STORE).build();
            FileInStream in = (FileInStream)closer.register((Closeable)this.mTfs.getInStream(fd, op));
            byte[] buf = new byte[0x800000];
            while (in.read(buf) != -1) {
            }
            n = 0;
        }
        catch (Throwable e) {
            try {
                try {
                    throw closer.rethrow(e);
                }
                catch (Throwable throwable) {
                    closer.close();
                    throw throwable;
                }
            }
            catch (TachyonException e2) {
                return -1;
            }
        }
        closer.close();
        return n;
    }

    public int copyFromLocalWildcard(List<File> srcFiles, TachyonURI dstPath) throws IOException {
        FileInfo dstFileInfo;
        try {
            this.mTfs.mkdir(dstPath);
        }
        catch (TachyonException e) {
            switch (e.getType()) {
                case INVALID_PATH: {
                    System.out.print("Fail to create directory (Invalid path): " + dstPath);
                    return -1;
                }
                case FILE_DOES_NOT_EXIST: {
                    break;
                }
                default: {
                    throw new IOException(e.getMessage());
                }
            }
        }
        try {
            TachyonFile dstFd = this.mTfs.open(dstPath);
            dstFileInfo = this.mTfs.getInfo(dstFd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (!dstFileInfo.isFolder) {
            System.out.println("The destination cannot be an existent file when the src contains wildcards.");
            return -1;
        }
        int exitCode = 0;
        for (File srcFile : srcFiles) {
            try {
                exitCode |= this.copyFromLocal(srcFile, new TachyonURI(PathUtils.concatPath((Object)dstPath.getPath(), (Object[])new Object[]{srcFile.getName()})));
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                exitCode |= 0xFFFFFFFF;
            }
        }
        return exitCode;
    }

    public int copyFromLocal(File srcFile, TachyonURI dstPath) throws IOException {
        int ret = this.copyPath(srcFile, this.mTfs, dstPath);
        if (ret == 0) {
            System.out.println("Copied " + srcFile.getPath() + " to " + dstPath);
        }
        return ret;
    }

    private int copyPath(File src, TachyonFileSystem tachyonClient, TachyonURI dstPath) throws IOException {
        if (!src.isDirectory()) {
            try {
                TachyonFile fd = tachyonClient.openIfExists(dstPath);
                if (fd != null) {
                    FileInfo tFile = tachyonClient.getInfo(fd);
                    if (tFile.isFolder) {
                        dstPath = dstPath.join(src.getName());
                    }
                }
            }
            catch (TachyonException e) {
                throw new IOException(e.getMessage());
            }
            Closer closer = Closer.create();
            try {
                FileOutStream os = (FileOutStream)closer.register((Closeable)tachyonClient.getOutStream(dstPath, OutStreamOptions.defaults()));
                FileInputStream in = (FileInputStream)closer.register((Closeable)new FileInputStream(src));
                FileChannel channel = (FileChannel)closer.register((Closeable)in.getChannel());
                ByteBuffer buf = ByteBuffer.allocate(0x800000);
                while (channel.read(buf) != -1) {
                    buf.flip();
                    os.write(buf.array(), 0, buf.limit());
                }
            }
            catch (TachyonException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                closer.close();
            }
            return 0;
        }
        try {
            tachyonClient.mkdir(dstPath);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        for (String file : src.list()) {
            File srcFile = new File(src, file);
            TachyonURI newPath = new TachyonURI(dstPath, new TachyonURI(file));
            if (this.copyPath(srcFile, tachyonClient, newPath) != -1) continue;
            return -1;
        }
        return 0;
    }

    public int copyWildcardToLocal(List<TachyonURI> srcPaths, File dstFile) throws IOException {
        if (dstFile.exists() && !dstFile.isDirectory()) {
            System.out.println("The destination cannot be an existent file when the src contains wildcards.");
            return -1;
        }
        if (!dstFile.exists()) {
            if (!dstFile.mkdirs()) {
                System.out.print("Fail to create directory: " + dstFile.getPath());
                return -1;
            }
            System.out.println("Create directory: " + dstFile.getPath());
        }
        int exitCode = 0;
        for (TachyonURI srcPath : srcPaths) {
            try {
                this.copyToLocal(srcPath, new File(dstFile.getAbsoluteFile(), srcPath.getName()));
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                exitCode |= 0xFFFFFFFF;
            }
        }
        return exitCode;
    }

    private int copyToLocal(TachyonURI srcPath, File dstFile) throws IOException {
        FileInfo srcFileInfo;
        TachyonFile srcFd;
        try {
            srcFd = this.mTfs.open(srcPath);
            srcFileInfo = this.mTfs.getInfo(srcFd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (srcFileInfo.isFolder) {
            if (!dstFile.exists()) {
                if (!dstFile.mkdirs()) {
                    System.out.println("mkdir failure for directory: " + dstFile.getAbsolutePath());
                    return -1;
                }
                System.out.println("Create directory: " + dstFile.getAbsolutePath());
            }
            int ret = 0;
            List files = null;
            try {
                files = this.mTfs.listStatus(srcFd);
            }
            catch (TachyonException e) {
                System.out.println(srcFd + " does not exist.");
                return -1;
            }
            for (FileInfo file : files) {
                ret |= this.copyToLocal(new TachyonURI(srcPath.getScheme(), srcPath.getAuthority(), file.getPath()), new File(dstFile.getAbsolutePath(), file.getName()));
            }
            return ret;
        }
        return this.copyFileToLocal(srcPath, dstFile);
    }

    public int copyFileToLocal(TachyonURI srcPath, File dstFile) throws IOException {
        TachyonFile srcFd;
        try {
            srcFd = this.mTfs.open(srcPath);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        Closer closer = Closer.create();
        try {
            InStreamOptions op = new InStreamOptions.Builder(this.mTachyonConf).setTachyonStorageType(TachyonStorageType.NO_STORE).build();
            FileInStream is = (FileInStream)closer.register((Closeable)this.mTfs.getInStream(srcFd, op));
            FileOutputStream out = (FileOutputStream)closer.register((Closeable)new FileOutputStream(dstFile));
            byte[] buf = new byte[0x4000000];
            int t = is.read(buf);
            while (t != -1) {
                out.write(buf, 0, t);
                t = is.read(buf);
            }
            System.out.println("Copied " + srcPath + " to " + dstFile.getPath());
            int n = 0;
            return n;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            closer.close();
        }
    }

    public int count(TachyonURI path) throws IOException {
        long[] values = this.countHelper(path);
        String format = "%-25s%-25s%-15s%n";
        System.out.format(format, "File Count", "Folder Count", "Total Bytes");
        System.out.format(format, values[0], values[1], values[2]);
        return 0;
    }

    private long[] countHelper(TachyonURI path) throws IOException {
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (!fInfo.isFolder) {
            return new long[]{1L, 0L, fInfo.length};
        }
        long[] rtn = new long[]{0L, 1L, 0L};
        List files = null;
        try {
            files = this.mTfs.listStatus(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        Collections.sort(files);
        for (FileInfo file : files) {
            long[] toAdd = this.countHelper(new TachyonURI(file.getPath()));
            rtn[0] = rtn[0] + toAdd[0];
            rtn[1] = rtn[1] + toAdd[1];
            rtn[2] = rtn[2] + toAdd[2];
        }
        return rtn;
    }

    public int fileinfo(TachyonURI path) throws IOException {
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (fInfo.isFolder) {
            System.out.println(path + " is a directory path so does not have file blocks.");
            return -1;
        }
        System.out.println(path + " with file id " + fd.getFileId() + " has the following blocks: ");
        Iterator i$ = fInfo.getBlockIds().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            System.out.println(TachyonBlockStore.get().getInfo(blockId));
        }
        return 0;
    }

    public int location(TachyonURI path) throws IOException {
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println(path + " with file id " + fd.getFileId() + " is on nodes: ");
        Iterator i$ = fInfo.getBlockIds().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            for (BlockLocation location : TachyonBlockStore.get().getInfo(blockId).getLocations()) {
                System.out.println(location.getWorkerAddress().getHost());
            }
        }
        return 0;
    }

    private List<FileInfo> listStatusSortedByIncreasingCreationTime(TachyonURI path) throws IOException {
        List files = null;
        try {
            TachyonFile fd = this.mTfs.open(path);
            files = this.mTfs.listStatus(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        Collections.sort(files, new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
                long t1 = fileInfo.creationTimeMs;
                long t2 = fileInfo2.creationTimeMs;
                if (t1 < t2) {
                    return -1;
                }
                if (t1 == t2) {
                    return 0;
                }
                return 1;
            }
        });
        return files;
    }

    public static Comparator<TachyonURI> createTachyonURIComparator() {
        return new Comparator<TachyonURI>(){

            @Override
            public int compare(TachyonURI tUri1, TachyonURI tUri2) {
                return tUri1.getPath().compareTo(tUri2.getPath());
            }
        };
    }

    public int ls(TachyonURI path) throws IOException {
        List<FileInfo> files = this.listStatusSortedByIncreasingCreationTime(path);
        String format = "%-10s%-25s%-15s%-5s%n";
        for (FileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, FormatUtils.getSizeFromBytes((long)file.getLength()), TfsShell.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
        }
        return 0;
    }

    public static String convertMsToDate(long Millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS");
        return formatter.format(new Date(Millis));
    }

    public int lsr(TachyonURI path) throws IOException {
        List<FileInfo> files = this.listStatusSortedByIncreasingCreationTime(path);
        String format = "%-10s%-25s%-15s%-5s%n";
        for (FileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, FormatUtils.getSizeFromBytes((long)file.getLength()), TfsShell.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
            if (!file.isFolder) continue;
            this.lsr(new TachyonURI(path.getScheme(), path.getAuthority(), file.getPath()));
        }
        return 0;
    }

    public int mkdir(TachyonURI path) {
        try {
            MkdirOptions options = new MkdirOptions.Builder(this.mTachyonConf).setRecursive(true).build();
            this.mTfs.mkdir(path, options);
            System.out.println("Successfully created directory " + path);
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
        catch (TachyonException e) {
            return -1;
        }
    }

    public int getUsedBytes() {
        try {
            long usedBytes = TachyonBlockStore.get().getUsedBytes();
            System.out.println("Used Bytes: " + usedBytes);
            return 0;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public int getCapacityBytes() {
        try {
            long capacityBytes = TachyonBlockStore.get().getCapacityBytes();
            System.out.println("Capacity Bytes: " + capacityBytes);
            return 0;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public int pin(TachyonURI path) {
        try {
            TachyonFile fd = this.mTfs.open(path);
            SetStateOptions options = new SetStateOptions.Builder(this.mTachyonConf).setPinned(true).build();
            this.mTfs.setState(fd, options);
            System.out.println("File '" + path + "' was successfully pinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + path + "' could not be pinned.");
            return -1;
        }
    }

    public void printUsage() {
        System.out.println("Usage: java TfsShell");
        System.out.println("       [cat <path>]");
        System.out.println("       [copyFromLocal <src> <remoteDst>]");
        System.out.println("       [copyToLocal <src> <localDst>]");
        System.out.println("       [count <path>]");
        System.out.println("       [du <path>]");
        System.out.println("       [fileinfo <path>]");
        System.out.println("       [free <file path|folder path>]");
        System.out.println("       [getUsedBytes]");
        System.out.println("       [getCapacityBytes]");
        System.out.println("       [load <path>]");
        System.out.println("       [loadMetadata <path>]");
        System.out.println("       [location <path>]");
        System.out.println("       [ls <path>]");
        System.out.println("       [lsr <path>]");
        System.out.println("       [mkdir <path>]");
        System.out.println("       [mount <tachyonPath> <ufsURI>]");
        System.out.println("       [mv <src> <dst>]");
        System.out.println("       [pin <path>]");
        System.out.println("       [report <path>]");
        System.out.println("       [request <tachyonaddress> <dependencyId>]");
        System.out.println("       [rm <path>]");
        System.out.println("       [rmr <path>]");
        System.out.println("       [tail <path>]");
        System.out.println("       [touch <path>]");
        System.out.println("       [unmount <tachyonPath>]");
        System.out.println("       [unpin <path>]");
    }

    public int getNumOfArgs(String cmd) {
        if (cmd.equals("getUsedBytes") || cmd.equals("getCapacityBytes") || cmd.equals("listLineages")) {
            return 0;
        }
        if (cmd.equals("cat") || cmd.equals("count") || cmd.equals("ls") || cmd.equals("lsr") || cmd.equals("mkdir") || cmd.equals("rm") || cmd.equals("rmr") || cmd.equals("tail") || cmd.equals("touch") || cmd.equals("load") || cmd.equals("fileinfo") || cmd.equals("location") || cmd.equals("report") || cmd.equals("pin") || cmd.equals("unpin") || cmd.equals("free") || cmd.equals("du") || cmd.equals("unmount") || cmd.equals("loadMetadata")) {
            return 1;
        }
        if (cmd.equals("copyFromLocal") || cmd.equals("copyToLocal") || cmd.equals("request") || cmd.equals("mount") || cmd.equals("mv") || cmd.equals("deleteLineage")) {
            return 2;
        }
        if (cmd.equals("createLineage")) {
            return 3;
        }
        return -1;
    }

    public int mount(String[] argv) throws IOException {
        TachyonURI tachyonPath = new TachyonURI(argv[1]);
        TachyonURI ufsPath = new TachyonURI(argv[2]);
        try {
            if (this.mTfs.mount(tachyonPath, ufsPath)) {
                System.out.println("Mounted " + ufsPath + " at " + tachyonPath);
                return 0;
            }
            System.out.println("mount: Failed to mount" + ufsPath + " to " + tachyonPath);
            return -1;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int unmount(TachyonURI path) throws IOException {
        try {
            if (this.mTfs.unmount(path)) {
                System.out.println("Unmounted " + path);
                return 0;
            }
            System.out.println("unmount: Failed to unmount" + path);
            return -1;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int loadMetadata(TachyonURI path) throws IOException {
        try {
            LoadMetadataOptions recursive = new LoadMetadataOptions.Builder(this.mTachyonConf).setRecursive(true).build();
            this.mTfs.loadMetadata(path, recursive);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        return 0;
    }

    public int rename(String[] argv) throws IOException {
        TachyonURI srcPath = new TachyonURI(argv[1]);
        TachyonURI dstPath = new TachyonURI(argv[2]);
        try {
            TachyonFile fd = this.mTfs.open(srcPath);
            if (this.mTfs.rename(fd, dstPath)) {
                System.out.println("Renamed " + srcPath + " to " + dstPath);
                return 0;
            }
            System.out.println("mv: Failed to rename " + srcPath + " to " + dstPath);
            return -1;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int report(TachyonURI path) throws IOException {
        try {
            TachyonFile fd = this.mTfs.open(path);
            this.mTfs.reportLostFile(fd);
            System.out.println(path + " with file id " + fd.getFileId() + " has reported been report lost.");
            this.listLineages();
            return 0;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int rm(TachyonURI path) throws IOException {
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (fInfo.isFolder) {
            System.out.println("rm: cannot remove a directory, please try rmr <path>");
            return -1;
        }
        try {
            this.mTfs.delete(fd);
            System.out.println(path + " has been removed");
            return 0;
        }
        catch (IOException ioe) {
            return -1;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int rmr(TachyonURI path) {
        try {
            DeleteOptions options = new DeleteOptions.Builder(this.mTachyonConf).setRecursive(true).build();
            TachyonFile fd = this.mTfs.open(path);
            this.mTfs.delete(fd, options);
            System.out.println(path + " has been removed");
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
        catch (TachyonException e) {
            return -1;
        }
    }

    public int du(TachyonURI path) throws IOException {
        long sizeInBytes = this.getFileOrFolderSize(this.mTfs, path);
        System.out.println(path + " is " + sizeInBytes + " bytes");
        return 0;
    }

    public int run(String[] argv) {
        if (argv.length == 0) {
            this.printUsage();
            return -1;
        }
        String cmd = argv[0];
        int numOfArgs = this.getNumOfArgs(cmd);
        if (numOfArgs == -1) {
            System.out.println(cmd + " is an unknown command.\n");
            this.printUsage();
            return -1;
        }
        if (numOfArgs < 3 && numOfArgs != argv.length - 1) {
            System.out.println(cmd + " takes " + numOfArgs + " arguments, " + " not " + (argv.length - 1) + "\n");
            this.printUsage();
            return -1;
        }
        try {
            if (numOfArgs == 0) {
                if (cmd.equals("getUsedBytes")) {
                    return this.getUsedBytes();
                }
                if (cmd.equals("getCapacityBytes")) {
                    return this.getCapacityBytes();
                }
                if (cmd.equals("listLineages")) {
                    return this.listLineages();
                }
            } else {
                if (numOfArgs == 1) {
                    TachyonURI inputPath = new TachyonURI(argv[1]);
                    if (cmd.equals("mkdir")) {
                        return this.mkdir(inputPath);
                    }
                    if (cmd.equals("touch")) {
                        return this.touch(inputPath);
                    }
                    if (cmd.equals("count")) {
                        return this.count(inputPath);
                    }
                    if (cmd.equals("unmount")) {
                        return this.unmount(inputPath);
                    }
                    if (cmd.equals("loadMetadata")) {
                        return this.loadMetadata(inputPath);
                    }
                    List<TachyonURI> paths = null;
                    paths = TfsShellUtils.getTachyonURIs(this.mTfs, inputPath);
                    if (paths.size() == 0) {
                        System.out.println(inputPath + " does not exist.");
                        return -1;
                    }
                    Collections.sort(paths, TfsShell.createTachyonURIComparator());
                    int exitCode = 0;
                    for (TachyonURI path : paths) {
                        try {
                            if (cmd.equals("cat")) {
                                exitCode |= this.cat(path);
                                continue;
                            }
                            if (cmd.equals("ls")) {
                                exitCode |= this.ls(path);
                                continue;
                            }
                            if (cmd.equals("lsr")) {
                                exitCode |= this.lsr(path);
                                continue;
                            }
                            if (cmd.equals("rm")) {
                                exitCode |= this.rm(path);
                                continue;
                            }
                            if (cmd.equals("rmr")) {
                                exitCode |= this.rmr(path);
                                continue;
                            }
                            if (cmd.equals("tail")) {
                                exitCode |= this.tail(path);
                                continue;
                            }
                            if (cmd.equals("load")) {
                                exitCode |= this.load(path);
                                continue;
                            }
                            if (cmd.equals("fileinfo")) {
                                exitCode |= this.fileinfo(path);
                                continue;
                            }
                            if (cmd.equals("location")) {
                                exitCode |= this.location(path);
                                continue;
                            }
                            if (cmd.equals("report")) {
                                exitCode |= this.report(path);
                                continue;
                            }
                            if (cmd.equals("pin")) {
                                exitCode |= this.pin(path);
                                continue;
                            }
                            if (cmd.equals("unpin")) {
                                exitCode |= this.unpin(path);
                                continue;
                            }
                            if (cmd.equals("free")) {
                                exitCode |= this.free(path);
                                continue;
                            }
                            if (!cmd.equals("du")) continue;
                            exitCode |= this.du(path);
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe.getMessage());
                            exitCode |= 0xFFFFFFFF;
                        }
                    }
                    return exitCode;
                }
                if (numOfArgs == 2) {
                    if (cmd.equals("copyFromLocal")) {
                        String srcPath = argv[1];
                        TachyonURI dstPath = new TachyonURI(argv[2]);
                        List<File> srcFiles = TfsShellUtils.getFiles(srcPath);
                        if (srcFiles.size() == 0) {
                            System.out.println("Local path " + srcPath + " does not exist.");
                            return -1;
                        }
                        if (srcPath.contains("*")) {
                            return this.copyFromLocalWildcard(srcFiles, dstPath);
                        }
                        return this.copyFromLocal(new File(srcPath), dstPath);
                    }
                    if (cmd.equals("copyToLocal")) {
                        TachyonURI srcPath = new TachyonURI(argv[1]);
                        File dstFile = new File(argv[2]);
                        List<TachyonURI> srcPaths = TfsShellUtils.getTachyonURIs(this.mTfs, srcPath);
                        if (srcPaths.size() == 0) {
                            System.out.println(srcPath.getPath() + " does not exist.");
                            return -1;
                        }
                        if (srcPath.containsWildcard()) {
                            return this.copyWildcardToLocal(srcPaths, dstFile);
                        }
                        return this.copyToLocal(srcPath, dstFile);
                    }
                    if (cmd.equals("mv")) {
                        return this.rename(argv);
                    }
                    if (cmd.equals("deleteLineage")) {
                        return this.deleteLineage(argv);
                    }
                    if (cmd.equals("mount")) {
                        return this.mount(argv);
                    }
                } else if (numOfArgs > 2 && cmd.equals("createLineage")) {
                    return this.createLineage(argv);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        return -1;
    }

    public int tail(TachyonURI path) throws IOException {
        FileInfo fInfo;
        TachyonFile fd;
        try {
            fd = this.mTfs.open(path);
            fInfo = this.mTfs.getInfo(fd);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        if (!fInfo.isFolder) {
            InStreamOptions op = new InStreamOptions.Builder(this.mTachyonConf).setTachyonStorageType(TachyonStorageType.NO_STORE).build();
            FileInStream is = null;
            try {
                is = this.mTfs.getInStream(fd, op);
                byte[] buf = new byte[1024];
                long bytesToRead = 0L;
                bytesToRead = fInfo.getLength() > 1024L ? 1024L : fInfo.getLength();
                is.skip(fInfo.getLength() - bytesToRead);
                int read = is.read(buf);
                if (read != -1) {
                    System.out.write(buf, 0, read);
                }
                int n = 0;
                return n;
            }
            catch (TachyonException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                is.close();
            }
        }
        System.out.println(path + " is not a file.");
        return -1;
    }

    public int touch(TachyonURI path) throws IOException {
        try {
            this.mTfs.getOutStream(path, new OutStreamOptions.Builder(this.mTachyonConf).setUnderStorageType(UnderStorageType.SYNC_PERSIST).build()).close();
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println(path + " has been created");
        return 0;
    }

    public int unpin(TachyonURI path) throws IOException {
        try {
            SetStateOptions options = new SetStateOptions.Builder(this.mTachyonConf).setPinned(false).build();
            TachyonFile fd = this.mTfs.open(path);
            this.mTfs.setState(fd, options);
            System.out.println("File '" + path + "' was successfully unpinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + path + "' could not be unpinned.");
            return -1;
        }
    }

    public int free(TachyonURI path) throws IOException {
        try {
            FreeOptions options = new FreeOptions.Builder(this.mTachyonConf).setRecursive(true).build();
            TachyonFile fd = this.mTfs.open(path);
            this.mTfs.free(fd, options);
            System.out.println(path + " was successfully freed from memory.");
            return 0;
        }
        catch (TachyonException e) {
            return -1;
        }
    }

    private long getFileOrFolderSize(TachyonFileSystem tachyonFS, TachyonURI path) throws IOException {
        List files;
        long sizeInBytes = 0L;
        try {
            TachyonFile inputFile = tachyonFS.open(path);
            files = tachyonFS.listStatus(inputFile);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        for (FileInfo file : files) {
            if (file.isFolder) {
                TachyonURI subFolder = new TachyonURI(file.getPath());
                sizeInBytes += this.getFileOrFolderSize(tachyonFS, subFolder);
                continue;
            }
            sizeInBytes += file.getLength();
        }
        return sizeInBytes;
    }

    private int createLineage(String[] argv) throws IOException {
        long lineageId;
        TachyonLineage tl = TachyonLineage.get();
        ArrayList inputFiles = Lists.newArrayList();
        if (!argv[1].equals("noInput")) {
            for (String path : argv[1].split(",")) {
                inputFiles.add(new TachyonURI(path));
            }
        }
        ArrayList outputFiles = Lists.newArrayList();
        for (String path : argv[2].split(",")) {
            outputFiles.add(new TachyonURI(path));
        }
        String cmd = "";
        for (int i = 3; i < argv.length; ++i) {
            cmd = cmd + argv[i] + " ";
        }
        String outputPath = ClientContext.getConf().get("tachyon.master.lineage.recompute.log.path");
        if (outputPath == null) {
            System.out.println("recompute output log is not configured");
            return -1;
        }
        CommandLineJob job = new CommandLineJob(cmd, new JobConf(outputPath));
        try {
            lineageId = tl.createLineage((List)inputFiles, (List)outputFiles, (Job)job);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println("Lineage " + lineageId + " has been created.");
        return 0;
    }

    private int deleteLineage(String[] argv) throws IOException {
        TachyonLineage tl = TachyonLineage.get();
        long lineageId = Long.parseLong(argv[1]);
        boolean cascade = Boolean.parseBoolean(argv[2]);
        DeleteLineageOptions options = new DeleteLineageOptions.Builder(new TachyonConf()).setCascade(cascade).build();
        try {
            tl.deleteLineage(lineageId, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Lineage '" + lineageId + "' could not be deleted.");
        }
        System.out.println("Lineage " + lineageId + " has been deleted.");
        return 0;
    }

    private int listLineages() throws IOException {
        TachyonLineage tl = TachyonLineage.get();
        List infos = tl.getLineageInfoList();
        for (LineageInfo info : infos) {
            System.out.println(info);
        }
        return 0;
    }
}

