/*
 * Decompiled with CFR 0.152.
 */
package tachyon.shell;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import tachyon.TachyonURI;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.conf.TachyonConf;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;
import tachyon.util.io.PathUtils;
import tachyon.util.network.NetworkAddressUtils;

public class TfsShellUtils {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    public static String getFilePath(String path, TachyonConf tachyonConf) throws IOException {
        if ((path = TfsShellUtils.validatePath(path, tachyonConf)).startsWith("tachyon://")) {
            path = path.substring("tachyon://".length());
        } else if (path.startsWith("tachyon-ft://")) {
            path = path.substring("tachyon-ft://".length());
        }
        return path.substring(path.indexOf("/"));
    }

    public static String validatePath(String path, TachyonConf tachyonConf) throws IOException {
        if (path.startsWith("tachyon://") || path.startsWith("tachyon-ft://")) {
            if (!path.contains(":")) {
                throw new IOException("Invalid Path: " + path + ". Use " + "tachyon://" + "host:port/ ," + "tachyon-ft://" + "host:port/" + " , or /file");
            }
            return path;
        }
        String hostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (TachyonConf)tachyonConf);
        int port = tachyonConf.getInt("tachyon.master.port");
        if (tachyonConf.getBoolean("tachyon.zookeeper.enabled")) {
            return PathUtils.concatPath((Object)("tachyon-ft://" + hostname + ":" + port), (Object[])new Object[]{path});
        }
        return PathUtils.concatPath((Object)("tachyon://" + hostname + ":" + port), (Object[])new Object[]{path});
    }

    public static List<TachyonURI> getTachyonURIs(TachyonFileSystem tachyonClient, TachyonURI inputURI) throws IOException {
        if (!inputURI.getPath().contains("*")) {
            return Lists.newArrayList((Object[])new TachyonURI[]{inputURI});
        }
        String inputPath = inputURI.getPath();
        TachyonURI parentURI = new TachyonURI(inputURI.getScheme(), inputURI.getAuthority(), inputPath.substring(0, inputPath.indexOf("*") + 1)).getParent();
        return TfsShellUtils.getTachyonURIs(tachyonClient, inputURI, parentURI);
    }

    private static List<TachyonURI> getTachyonURIs(TachyonFileSystem tachyonClient, TachyonURI inputURI, TachyonURI parentDir) throws IOException {
        LinkedList<TachyonURI> res = new LinkedList<TachyonURI>();
        List files = null;
        try {
            TachyonFile parentFile = tachyonClient.open(parentDir);
            files = tachyonClient.listStatus(parentFile);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
        for (FileInfo file : files) {
            TachyonURI dirURI;
            String prefix;
            TachyonURI fileURI = new TachyonURI(inputURI.getScheme(), inputURI.getAuthority(), file.getPath());
            if (TfsShellUtils.match(fileURI, inputURI)) {
                res.add(fileURI);
                continue;
            }
            if (!file.isFolder || (prefix = inputURI.getLeadingPath((dirURI = new TachyonURI(inputURI.getScheme(), inputURI.getAuthority(), file.getPath())).getDepth())) == null || !TfsShellUtils.match(dirURI, new TachyonURI(prefix))) continue;
            res.addAll(TfsShellUtils.getTachyonURIs(tachyonClient, inputURI, dirURI));
        }
        return res;
    }

    public static List<File> getFiles(String inputPath) {
        File file = new File(inputPath);
        if (!inputPath.contains("*")) {
            LinkedList<File> res = new LinkedList<File>();
            if (file.exists()) {
                res.add(file);
            }
            return res;
        }
        String prefix = inputPath.substring(0, inputPath.indexOf("*") + 1);
        String parent = new File(prefix).getParent();
        return TfsShellUtils.getFiles(inputPath, parent);
    }

    private static List<File> getFiles(String inputPath, String parent) {
        LinkedList<File> res = new LinkedList<File>();
        File pFile = new File(parent);
        if (!pFile.exists() || !pFile.isDirectory()) {
            return res;
        }
        if (pFile.isDirectory() && pFile.canRead()) {
            for (File file : pFile.listFiles()) {
                TachyonURI dirURI;
                String prefix;
                if (TfsShellUtils.match(file.getPath(), inputPath)) {
                    res.add(file);
                    continue;
                }
                if (!file.isDirectory() || (prefix = new TachyonURI(inputPath).getLeadingPath((dirURI = new TachyonURI(file.getPath())).getDepth())) == null || !TfsShellUtils.match(dirURI, new TachyonURI(prefix))) continue;
                res.addAll(TfsShellUtils.getFiles(inputPath, dirURI.getPath()));
            }
        }
        return res;
    }

    private static String escape(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    private static String replaceWildcards(String text) {
        return TfsShellUtils.escape(text).replace("\\*", ".*");
    }

    private static boolean match(TachyonURI fileURI, TachyonURI patternURI) {
        return TfsShellUtils.escape(fileURI.getPath()).matches(TfsShellUtils.replaceWildcards(patternURI.getPath()));
    }

    protected static boolean match(String filePath, String patternPath) {
        return TfsShellUtils.match(new TachyonURI(filePath), new TachyonURI(patternPath));
    }
}

