/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.mockbehavior.impl;

import org.unitils.core.UnitilsException;
import org.unitils.core.util.ObjectToInjectHolder;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.mockbehavior.ValidatableMockBehavior;
import org.unitils.util.ReflectionUtils;

public class ValueReturningMockBehavior
implements ValidatableMockBehavior {
    private Object valueToReturn;

    public ValueReturningMockBehavior(Object valueToReturn) {
        this.valueToReturn = this.unwrapValueToReturnIfNeeded(valueToReturn);
    }

    public void assertCanExecute(ProxyInvocation proxyInvocation) throws UnitilsException {
        Class<?> returnType = proxyInvocation.getMethod().getReturnType();
        if (returnType == Void.TYPE) {
            throw new UnitilsException("Trying to make a void method return a value");
        }
        if (this.valueToReturn != null && !ReflectionUtils.isAssignable(this.valueToReturn.getClass(), returnType)) {
            throw new UnitilsException("Trying to make a method return a value who's type is not compatible with the return type. Value type: " + this.valueToReturn.getClass() + ", return type: " + returnType);
        }
    }

    public Object execute(ProxyInvocation proxyInvocation) {
        return this.valueToReturn;
    }

    protected Object unwrapValueToReturnIfNeeded(Object valueToReturn) {
        if (valueToReturn != null && valueToReturn instanceof ObjectToInjectHolder) {
            ObjectToInjectHolder objectToInjectHolder = (ObjectToInjectHolder)valueToReturn;
            return objectToInjectHolder.getObjectToInject();
        }
        return valueToReturn;
    }
}

