/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.event.BaseViburLogger;
import org.vibur.dbcp.event.ConnectionHook;
import org.vibur.dbcp.event.ExceptionListener;
import org.vibur.dbcp.event.ViburLogger;
import org.vibur.dbcp.pool.PoolReducer;
import org.vibur.objectpool.BasePool;

public class ViburDBCPConfig {
    private static final Logger logger = LoggerFactory.getLogger(ViburDBCPConfig.class);
    public static final String SQLSTATE_POOL_NOTSTARTED_ERROR = "VI000";
    public static final String SQLSTATE_POOL_CLOSED_ERROR = "VI001";
    public static final String SQLSTATE_TIMEOUT_ERROR = "VI002";
    public static final String SQLSTATE_CONN_INIT_ERROR = "VI003";
    public static final String SQLSTATE_OBJECT_CLOSED_ERROR = "VI004";
    public static final String SQLSTATE_WRAPPER_ERROR = "VI005";
    public static final int STATEMENT_CACHE_MAX_SIZE = 2000;
    private String driverClassName = null;
    private String jdbcUrl;
    private String username;
    private String password;
    private DataSource externalDataSource = null;
    private int connectionIdleLimitInSeconds = 5;
    private int validateTimeoutInSeconds = 3;
    public static final String IS_VALID_QUERY = "isValid";
    private String testConnectionQuery = "isValid";
    private String initSQL = null;
    private boolean useNetworkTimeout = false;
    private Executor networkTimeoutExecutor = null;
    private int poolInitialSize = 10;
    private int poolMaxSize = 100;
    private boolean poolFair = true;
    private boolean poolEnableConnectionTracking = false;
    private String name = this.registerDefaultName();
    private boolean enableJMX = true;
    private String poolReducerClass = PoolReducer.class.getName();
    private int reducerTimeIntervalInSeconds = 60;
    private int reducerSamples = 20;
    private long connectionTimeoutInMs = 30000L;
    private int loginTimeoutInSeconds = 10;
    private long acquireRetryDelayInMs = 1000L;
    private int acquireRetryAttempts = 3;
    private int statementCacheMaxSize = 0;
    private StatementCache statementCache = null;
    private String criticalSQLStates = "08001,08006,08007,08S01,57P01,57P02,57P03,JZ0C0,JZ0C1";
    private long logConnectionLongerThanMs = 3000L;
    private boolean logStackTraceForLongConnection = false;
    private long logQueryExecutionLongerThanMs = 3000L;
    private boolean logStackTraceForLongQueryExecution = false;
    private long logLargeResultSet = 500L;
    private boolean logStackTraceForLargeResultSet = false;
    private boolean resetDefaultsAfterUse = false;
    private Boolean defaultAutoCommit;
    private Boolean defaultReadOnly;
    private String defaultTransactionIsolation;
    private String defaultCatalog;
    private Integer defaultTransactionIsolationValue;
    private boolean clearSQLWarnings = false;
    private ConnectionHook initConnectionHook = null;
    private ConnectionHook connectionHook = null;
    private ConnectionHook closeConnectionHook = null;
    private ViburLogger viburLogger = new BaseViburLogger();
    private ExceptionListener exceptionListener = null;
    private boolean poolFifo = false;
    private BasePool pool = null;
    private static final AtomicInteger idGenerator = new AtomicInteger(1);
    private static final ConcurrentMap<String, Boolean> names = new ConcurrentHashMap<String, Boolean>();

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DataSource getExternalDataSource() {
        return this.externalDataSource;
    }

    public void setExternalDataSource(DataSource externalDataSource) {
        this.externalDataSource = externalDataSource;
    }

    public int getConnectionIdleLimitInSeconds() {
        return this.connectionIdleLimitInSeconds;
    }

    public void setConnectionIdleLimitInSeconds(int connectionIdleLimitInSeconds) {
        this.connectionIdleLimitInSeconds = connectionIdleLimitInSeconds;
    }

    public int getValidateTimeoutInSeconds() {
        return this.validateTimeoutInSeconds;
    }

    public void setValidateTimeoutInSeconds(int validateTimeoutInSeconds) {
        this.validateTimeoutInSeconds = validateTimeoutInSeconds;
    }

    public String getTestConnectionQuery() {
        return this.testConnectionQuery;
    }

    public void setTestConnectionQuery(String testConnectionQuery) {
        this.testConnectionQuery = testConnectionQuery;
    }

    public String getInitSQL() {
        return this.initSQL;
    }

    public void setInitSQL(String initSQL) {
        this.initSQL = initSQL;
    }

    public boolean isUseNetworkTimeout() {
        return this.useNetworkTimeout;
    }

    public void setUseNetworkTimeout(boolean useNetworkTimeout) {
        this.useNetworkTimeout = useNetworkTimeout;
    }

    public Executor getNetworkTimeoutExecutor() {
        return this.networkTimeoutExecutor;
    }

    public void setNetworkTimeoutExecutor(Executor networkTimeoutExecutor) {
        this.networkTimeoutExecutor = networkTimeoutExecutor;
    }

    public int getPoolInitialSize() {
        return this.poolInitialSize;
    }

    public void setPoolInitialSize(int poolInitialSize) {
        this.poolInitialSize = poolInitialSize;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public boolean isPoolFair() {
        return this.poolFair;
    }

    public void setPoolFair(boolean poolFair) {
        this.poolFair = poolFair;
    }

    public boolean isPoolEnableConnectionTracking() {
        return this.poolEnableConnectionTracking;
    }

    public void setPoolEnableConnectionTracking(boolean poolEnableConnectionTracking) {
        this.poolEnableConnectionTracking = poolEnableConnectionTracking;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.registerName(name)) {
            logger.warn("DataSource name {} is not unique, using {} instead", (Object)name, (Object)this.name);
        }
    }

    public boolean isEnableJMX() {
        return this.enableJMX;
    }

    public void setEnableJMX(boolean enableJMX) {
        this.enableJMX = enableJMX;
    }

    public String getPoolReducerClass() {
        return this.poolReducerClass;
    }

    public void setPoolReducerClass(String poolReducerClass) {
        this.poolReducerClass = poolReducerClass;
    }

    public int getReducerTimeIntervalInSeconds() {
        return this.reducerTimeIntervalInSeconds;
    }

    public void setReducerTimeIntervalInSeconds(int reducerTimeIntervalInSeconds) {
        this.reducerTimeIntervalInSeconds = reducerTimeIntervalInSeconds;
    }

    public int getReducerSamples() {
        return this.reducerSamples;
    }

    public void setReducerSamples(int reducerSamples) {
        this.reducerSamples = reducerSamples;
    }

    public long getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public void setConnectionTimeoutInMs(long connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public int getLoginTimeoutInSeconds() {
        return this.loginTimeoutInSeconds;
    }

    public void setLoginTimeoutInSeconds(int loginTimeoutInSeconds) {
        this.loginTimeoutInSeconds = loginTimeoutInSeconds;
    }

    public long getAcquireRetryDelayInMs() {
        return this.acquireRetryDelayInMs;
    }

    public void setAcquireRetryDelayInMs(long acquireRetryDelayInMs) {
        this.acquireRetryDelayInMs = acquireRetryDelayInMs;
    }

    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.acquireRetryAttempts = acquireRetryAttempts;
    }

    public int getStatementCacheMaxSize() {
        return this.statementCacheMaxSize;
    }

    public void setStatementCacheMaxSize(int statementCacheMaxSize) {
        this.statementCacheMaxSize = statementCacheMaxSize;
    }

    public StatementCache getStatementCache() {
        return this.statementCache;
    }

    public void setStatementCache(StatementCache statementCache) {
        this.statementCache = statementCache;
    }

    public String getCriticalSQLStates() {
        return this.criticalSQLStates;
    }

    public void setCriticalSQLStates(String criticalSQLStates) {
        this.criticalSQLStates = criticalSQLStates;
    }

    public long getLogConnectionLongerThanMs() {
        return this.logConnectionLongerThanMs;
    }

    public void setLogConnectionLongerThanMs(long logConnectionLongerThanMs) {
        this.logConnectionLongerThanMs = logConnectionLongerThanMs;
    }

    public boolean isLogStackTraceForLongConnection() {
        return this.logStackTraceForLongConnection;
    }

    public void setLogStackTraceForLongConnection(boolean logStackTraceForLongConnection) {
        this.logStackTraceForLongConnection = logStackTraceForLongConnection;
    }

    public long getLogQueryExecutionLongerThanMs() {
        return this.logQueryExecutionLongerThanMs;
    }

    public void setLogQueryExecutionLongerThanMs(long logQueryExecutionLongerThanMs) {
        this.logQueryExecutionLongerThanMs = logQueryExecutionLongerThanMs;
    }

    public boolean isLogStackTraceForLongQueryExecution() {
        return this.logStackTraceForLongQueryExecution;
    }

    public void setLogStackTraceForLongQueryExecution(boolean logStackTraceForLongQueryExecution) {
        this.logStackTraceForLongQueryExecution = logStackTraceForLongQueryExecution;
    }

    public long getLogLargeResultSet() {
        return this.logLargeResultSet;
    }

    public void setLogLargeResultSet(long logLargeResultSet) {
        this.logLargeResultSet = logLargeResultSet;
    }

    public boolean isLogStackTraceForLargeResultSet() {
        return this.logStackTraceForLargeResultSet;
    }

    public void setLogStackTraceForLargeResultSet(boolean logStackTraceForLargeResultSet) {
        this.logStackTraceForLargeResultSet = logStackTraceForLargeResultSet;
    }

    public boolean isResetDefaultsAfterUse() {
        return this.resetDefaultsAfterUse;
    }

    public void setResetDefaultsAfterUse(boolean resetDefaultsAfterUse) {
        this.resetDefaultsAfterUse = resetDefaultsAfterUse;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public String getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public Integer getDefaultTransactionIsolationValue() {
        return this.defaultTransactionIsolationValue;
    }

    public void setDefaultTransactionIsolationValue(Integer defaultTransactionIsolationValue) {
        this.defaultTransactionIsolationValue = defaultTransactionIsolationValue;
    }

    public boolean isClearSQLWarnings() {
        return this.clearSQLWarnings;
    }

    public void setClearSQLWarnings(boolean clearSQLWarnings) {
        this.clearSQLWarnings = clearSQLWarnings;
    }

    public ConnectionHook getInitConnectionHook() {
        return this.initConnectionHook;
    }

    public void setInitConnectionHook(ConnectionHook initConnectionHook) {
        this.initConnectionHook = initConnectionHook;
    }

    public ConnectionHook getConnectionHook() {
        return this.connectionHook;
    }

    public void setConnectionHook(ConnectionHook connectionHook) {
        this.connectionHook = connectionHook;
    }

    public ConnectionHook getCloseConnectionHook() {
        return this.closeConnectionHook;
    }

    public void setCloseConnectionHook(ConnectionHook closeConnectionHook) {
        this.closeConnectionHook = closeConnectionHook;
    }

    public ViburLogger getViburLogger() {
        return this.viburLogger;
    }

    public void setViburLogger(ViburLogger viburLogger) {
        this.viburLogger = viburLogger;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public boolean isPoolFifo() {
        return this.poolFifo;
    }

    public void setPoolFifo(boolean poolFifo) {
        this.poolFifo = poolFifo;
    }

    public BasePool getPool() {
        return this.pool;
    }

    public void setPool(BasePool pool) {
        this.pool = pool;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {driverClassName='" + this.driverClassName + '\'' + ", jdbcUrl='" + this.jdbcUrl + '\'' + ", externalDataSource=" + this.externalDataSource + ", poolInitialSize=" + this.poolInitialSize + ", poolMaxSize=" + this.poolMaxSize + ", poolFair=" + this.poolFair + ", name='" + this.name + '\'' + ", statementCacheMaxSize=" + this.statementCacheMaxSize + '}';
    }

    private String registerDefaultName() {
        String defaultName;
        while (names.putIfAbsent(defaultName = "p" + Integer.toString(idGenerator.getAndIncrement()), Boolean.TRUE) != null) {
        }
        return defaultName;
    }

    private boolean registerName(String name) {
        if (name == null || name.isEmpty() || names.putIfAbsent(name, Boolean.TRUE) != null) {
            return false;
        }
        this.unregisterName();
        this.name = name;
        return true;
    }

    void unregisterName() {
        names.remove(this.name);
    }
}

