/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.cache;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Arrays;

public class ConnMethod {
    private final Connection target;
    private final Method method;
    private final Object[] args;

    public ConnMethod(Connection target, Method method, Object[] args) {
        if (target == null || method == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.method = method;
        this.args = args;
    }

    public Connection getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnMethod that = (ConnMethod)o;
        return this.target == that.target && this.method.equals(that.method) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public String toString() {
        return String.format("connection %s, method %s, args %s", this.target, this.method, Arrays.toString(this.args));
    }
}

