/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.event;

import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.event.ViburLogger;
import org.vibur.dbcp.util.QueryUtils;
import org.vibur.dbcp.util.ViburUtils;

public class BaseViburLogger
implements ViburLogger {
    private static final Logger logger = LoggerFactory.getLogger(BaseViburLogger.class);

    @Override
    public void logGetConnection(String poolName, Connection connProxy, long timeout, long timeTaken, StackTraceElement[] stackTrace) {
        StringBuilder log = new StringBuilder(4096).append(String.format("Call to getConnection(%d) from pool %s took %d ms, connProxy = %s", timeout, poolName, timeTaken, connProxy));
        if (stackTrace != null) {
            log.append('\n').append(ViburUtils.getStackTraceAsString(stackTrace));
        }
        logger.warn(log.toString());
    }

    @Override
    public void logQuery(String poolName, String sqlQuery, List<Object[]> queryParams, long timeTaken, StackTraceElement[] stackTrace) {
        StringBuilder message = new StringBuilder(4096).append(String.format("SQL query execution from pool %s took %d ms:\n%s", poolName, timeTaken, QueryUtils.formatSql(sqlQuery, queryParams)));
        if (stackTrace != null) {
            message.append("\n").append(ViburUtils.getStackTraceAsString(stackTrace));
        }
        logger.warn(message.toString());
    }

    @Override
    public void logResultSetSize(String poolName, String sqlQuery, List<Object[]> queryParams, long resultSetSize, StackTraceElement[] stackTrace) {
        StringBuilder message = new StringBuilder(4096).append(String.format("SQL query execution from pool %s retrieved a ResultSet with size %d:\n%s", poolName, resultSetSize, QueryUtils.formatSql(sqlQuery, queryParams)));
        if (stackTrace != null) {
            message.append("\n").append(ViburUtils.getStackTraceAsString(stackTrace));
        }
        logger.warn(message.toString());
    }
}

