/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.cache.ConnMethod;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.proxy.AbstractInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.Proxy;

class ConnectionInvocationHandler
extends AbstractInvocationHandler<Connection> {
    private final ConnHolder conn;
    private final PoolOperations poolOperations;
    private final ViburDBCPConfig config;

    ConnectionInvocationHandler(ConnHolder conn, PoolOperations poolOperations, ViburDBCPConfig config) {
        super(conn.value(), config, new ExceptionCollector(config));
        this.conn = conn;
        this.poolOperations = poolOperations;
        this.config = config;
    }

    @Override
    Object doInvoke(Connection proxy, Method method, Object[] args) throws Throwable {
        boolean aborted;
        String methodName = method.getName();
        boolean bl = aborted = methodName == "abort";
        if (aborted || methodName == "close") {
            return this.processCloseOrAbort(aborted, method, args);
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        if (methodName == "isValid") {
            return this.isClosed() ? Boolean.valueOf(false) : this.targetInvoke(method, args);
        }
        this.ensureNotClosed();
        if (methodName == "createStatement") {
            StatementHolder statement = this.getUncachedStatement(method, args);
            return Proxy.newProxyStatement(statement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "prepareStatement") {
            StatementHolder pStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyPreparedStatement(pStatement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "prepareCall") {
            StatementHolder cStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyCallableStatement(cStatement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "getMetaData") {
            DatabaseMetaData rawDatabaseMetaData = (DatabaseMetaData)this.targetInvoke(method, args);
            return Proxy.newProxyDatabaseMetaData(rawDatabaseMetaData, proxy, this.config, this.getExceptionCollector());
        }
        return super.doInvoke(proxy, method, args);
    }

    private StatementHolder getCachedStatement(Method method, Object[] args) throws Throwable {
        StatementCache statementCache = this.config.getStatementCache();
        if (statementCache != null) {
            return statementCache.retrieve(new ConnMethod((Connection)this.getTarget(), method, args), this);
        }
        return this.getUncachedStatement(method, args);
    }

    private StatementHolder getUncachedStatement(Method method, Object[] args) throws Throwable {
        Statement rawStatement = (Statement)this.targetInvoke(method, args);
        return new StatementHolder(rawStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processCloseOrAbort(boolean aborted, Method method, Object[] args) throws Throwable {
        if (this.getAndSetClosed()) {
            return null;
        }
        try {
            Object object = aborted ? this.targetInvoke(method, args) : null;
            return object;
        }
        finally {
            this.poolOperations.restore(this.conn, aborted, this.getExceptionCollector().getExceptions());
        }
    }
}

