/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.api.model.ExclusionInfo;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.report.PolicyCheckReport;
import org.whitesource.maven.WhitesourceMojo;
import org.whitesource.maven.utils.dependencies.AetherArtifact;
import org.whitesource.maven.utils.dependencies.AetherDependency;
import org.whitesource.maven.utils.dependencies.AetherDependencyNode;
import org.whitesource.maven.utils.dependencies.AetherExclusion;
import org.whitesource.maven.utils.dependencies.DependencyGraphFactory;

public abstract class AgentMojo
extends WhitesourceMojo {
    private static final String POM = "pom";
    private static final String SCOPE_TEST = "test";
    private static final String SCOPE_PROVIDED = "provided";
    private static final String FILENAME_PATTERN = "{0}-{1}.{2}";
    public static final String DASH = "-";
    @Parameter(alias="timeFormat", property="org.whitesource.timeFormat", required=false)
    protected String timeFormat;
    @Parameter(alias="orgToken", property="org.whitesource.orgToken", required=false)
    protected String orgToken;
    @Parameter(alias="userKey", property="org.whitesource.userKey", required=false)
    protected String userKey;
    @Parameter(alias="forceUpdate", property="org.whitesource.forceUpdate", required=false, defaultValue="false")
    protected boolean forceUpdate;
    @Parameter(alias="forceCheckAllDependencies", property="org.whitesource.forceCheckAllDependencies", required=false, defaultValue="false")
    protected boolean forceCheckAllDependencies;
    @Parameter(alias="product", property="org.whitesource.product", required=false)
    protected String product;
    @Parameter(alias="productVersion", property="org.whitesource.productVersion", required=false)
    protected String productVersion;
    @Parameter(alias="outputDirectory", property="org.whitesource.outputDirectory", required=false, defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Parameter(alias="projectToken", property="org.whitesource.projectToken", required=false)
    protected String projectToken;
    @Parameter(alias="moduleTokens", property="org.whitesource.moduleTokens", required=false)
    protected Map<String, String> moduleTokens = new HashMap<String, String>();
    @Parameter(alias="specialModuleTokens", property="org.whitesource.specialModuleTokens", required=false)
    protected Properties specialModuleTokens = new Properties();
    @Parameter(alias="ignore", property="org.whitesource.ignore", required=false, defaultValue="false")
    protected boolean ignore;
    @Parameter(alias="includes", property="org.whitesource.includes", required=false, defaultValue="")
    protected String[] includes;
    @Parameter(alias="excludes", property="org.whitesource.excludes", required=false, defaultValue="")
    protected String[] excludes;
    @Deprecated
    @Parameter(alias="ignoredScopes", property="org.whitesource.scope", required=false)
    protected String[] scope;
    @Parameter(alias="ignoredScopes", property="org.whitesource.ignoredScopes", required=false)
    protected String[] ignoredScopes;
    @Parameter(alias="ignorePomModules", property="org.whitesource.ignorePomModules", required=false, defaultValue="true")
    protected boolean ignorePomModules;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected Collection<MavenProject> reactorProjects;
    @Parameter(alias="aggregateModules", property="org.whitesource.aggregateModules", required=false, defaultValue="false")
    protected boolean aggregateModules;
    @Parameter(alias="preserveModuleInfo", property="org.whitesource.preserveModuleInfo", required=false, defaultValue="false")
    protected boolean preserveModuleInfo;
    @Parameter(alias="aggregateProjectName", property="org.whitesource.aggregateProjectName", required=false)
    protected String aggregateProjectName;
    @Parameter(alias="aggregateProjectToken", property="org.whitesource.aggregateProjectToken", required=false)
    protected String aggregateProjectToken;
    @Parameter(alias="requesterEmail", property="org.whitesource.requesterEmail", required=false)
    protected String requesterEmail;
    @Parameter(alias="ignoreDependencyResolutionErrors", property="org.whitesource.ignoreDependencyResolutionErrors", required=false, defaultValue="false")
    protected boolean ignoreDependencyResolutionErrors;
    @Parameter(alias="orgTokenFile", property="org.whitesource.orgTokenFile", required=false)
    protected String orgTokenFile;
    @Parameter(alias="userKeyFile", property="org.whitesource.orgTokenFile", required=false)
    protected String userKeyFile;

    protected AgentMojo() {
    }

    @Override
    protected void init() throws MojoFailureException {
        super.init();
        for (Map.Entry<Object, Object> entry : this.specialModuleTokens.entrySet()) {
            this.moduleTokens.put(entry.getKey().toString(), entry.getValue().toString());
        }
        MavenProject topLevelProject = this.session.getTopLevelProject();
        if (topLevelProject != null) {
            if (StringUtils.isBlank((String)this.product)) {
                this.product = topLevelProject.getName();
            }
            if (StringUtils.isBlank((String)this.product)) {
                this.product = topLevelProject.getArtifactId();
            }
        }
        Properties systemProperties = this.session.getSystemProperties();
        this.timeFormat = systemProperties.getProperty("org.whitesource.timeFormat", this.timeFormat);
        if (this.timeFormat == null) {
            this.timeFormat = "[HH:mm:ss] ";
        }
        this.dateFormat = new SimpleDateFormat(this.timeFormat);
        this.orgTokenFile = systemProperties.getProperty("org.whitesource.orgTokenFile", this.orgTokenFile);
        String orgTokenFromFile = this.readOrgTokenFile(this.orgTokenFile);
        this.orgToken = StringUtils.isNotEmpty((String)orgTokenFromFile) ? orgTokenFromFile : systemProperties.getProperty("org.whitesource.orgToken", this.orgToken);
        if (StringUtils.isEmpty((String)this.orgToken)) {
            throw new MojoFailureException("The parameter 'orgToken' is missing or invalid");
        }
        this.userKeyFile = systemProperties.getProperty("org.whitesource.userKeyFile", this.userKeyFile);
        String userKeyFromFile = this.readOrgTokenFile(this.userKeyFile);
        this.userKey = StringUtils.isNotEmpty((String)userKeyFromFile) ? userKeyFromFile : systemProperties.getProperty("org.whitesource.userKey", this.userKey);
        this.ignorePomModules = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.ignorePomModules", Boolean.toString(this.ignorePomModules)));
        this.forceUpdate = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.forceUpdate", Boolean.toString(this.forceUpdate)));
        this.product = systemProperties.getProperty("org.whitesource.product", this.product);
        this.productVersion = systemProperties.getProperty("org.whitesource.productVersion", this.productVersion);
        this.requesterEmail = systemProperties.getProperty("org.whitesource.requesterEmail", this.requesterEmail);
        this.forceCheckAllDependencies = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.forceCheckAllDependencies", Boolean.toString(this.forceCheckAllDependencies)));
        this.ignoreDependencyResolutionErrors = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.ignoreDependencyResolutionErrors", Boolean.toString(this.ignoreDependencyResolutionErrors)));
        this.aggregateModules = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.aggregateModules", Boolean.toString(this.aggregateModules)));
        this.aggregateProjectName = systemProperties.getProperty("org.whitesource.aggregateProjectName", this.aggregateProjectName);
        this.aggregateProjectToken = systemProperties.getProperty("org.whitesource.aggregateProjectToken", this.aggregateProjectToken);
        this.preserveModuleInfo = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.preserveModuleInfo", Boolean.toString(this.preserveModuleInfo)));
        HashSet<String> ignoredScopeSet = new HashSet<String>();
        if (this.scope != null) {
            for (String ignoredScope : this.scope) {
                ignoredScopeSet.add(ignoredScope);
            }
        }
        if (this.ignoredScopes != null) {
            for (String ignoredScope : this.ignoredScopes) {
                ignoredScopeSet.add(ignoredScope);
            }
        }
        if (ignoredScopeSet.isEmpty()) {
            this.ignoredScopes = new String[2];
            this.ignoredScopes[0] = SCOPE_TEST;
            this.ignoredScopes[1] = SCOPE_PROVIDED;
        } else {
            this.ignoredScopes = new String[ignoredScopeSet.size()];
            int i = 0;
            for (String ignoredScope : ignoredScopeSet) {
                this.ignoredScopes[i++] = ignoredScope;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readOrgTokenFile(String keyFile) {
        String orgTokenToReturn = null;
        if (StringUtils.isNotEmpty((String)keyFile)) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(keyFile));
                orgTokenToReturn = bufferedReader.readLine();
            }
            catch (IOException e) {
                this.warn("Failed to read the org token from the file " + keyFile + ", using the orgToken parameter instead.");
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException ex) {
                    this.warn("Failed to close the file " + keyFile + ".");
                }
            }
        }
        return orgTokenToReturn;
    }

    private DependencyInfo getDependencyInfo(AetherDependencyNode dependencyNode) {
        DependencyInfo info = new DependencyInfo();
        AetherDependency dependency = dependencyNode.getDependency();
        AetherArtifact artifact = dependency.getArtifact();
        info.setGroupId(artifact.getGroupId());
        info.setArtifactId(artifact.getArtifactId());
        info.setVersion(artifact.getVersion());
        info.setScope(dependency.getScope());
        info.setClassifier(artifact.getClassifier());
        info.setOptional(dependency.isOptional());
        info.setType(artifact.getExtension());
        info.setDependencyType(DependencyType.MAVEN);
        File artifactFile = artifact.getFile();
        if (artifactFile != null && artifactFile.exists()) {
            try {
                info.setSha1(ChecksumUtils.calculateSHA1((File)artifactFile));
                info.setSystemPath(artifactFile.getAbsolutePath());
                String filename = artifactFile.getName();
                if (StringUtils.isNotBlank((String)filename)) {
                    info.setFilename(filename);
                } else if (StringUtils.isNotBlank((String)artifact.getExtension())) {
                    info.setFilename(this.getFilename(artifact));
                }
            }
            catch (IOException e) {
                this.debug("Error calculating SHA-1 for " + dependency.toString());
            }
        } else if (StringUtils.isNotBlank((String)artifact.getExtension())) {
            info.setFilename(this.getFilename(artifact));
        }
        for (AetherExclusion exclusion : dependency.getExclusions()) {
            info.getExclusions().add(new ExclusionInfo(exclusion.getArtifactId(), exclusion.getGroupId()));
        }
        for (AetherDependencyNode child : dependencyNode.getChildren()) {
            info.getChildren().add(this.getDependencyInfo(child));
        }
        return info;
    }

    protected void debugProjectInfos(Collection<AgentProjectInfo> projectInfos) {
        this.debug("----------------- dumping projectInfos -----------------");
        this.debug("Total Number of Projects : " + projectInfos.size());
        for (AgentProjectInfo projectInfo : projectInfos) {
            this.debug("Project Coordinates: " + projectInfo.getCoordinates().toString());
            this.debug("Project Parent Coordinates: " + (projectInfo.getParentCoordinates() == null ? "" : projectInfo.getParentCoordinates().toString()));
            this.debug("Project Token: " + projectInfo.getProjectToken());
            this.debug("Total Number of Dependencies: " + projectInfo.getDependencies().size());
            for (DependencyInfo info : projectInfo.getDependencies()) {
                this.debug(info.toString() + " SHA-1: " + info.getSha1());
            }
        }
        this.debug("----------------- dump finished -----------------");
    }

    protected AgentProjectInfo processProject(MavenProject project) throws MojoExecutionException, DependencyResolutionException {
        long startTime = System.currentTimeMillis();
        this.info("Processing " + project.getId());
        AgentProjectInfo projectInfo = new AgentProjectInfo();
        if (project.equals((Object)this.mavenProject)) {
            projectInfo.setProjectToken(this.projectToken);
        } else {
            projectInfo.setProjectToken(this.moduleTokens.get(project.getArtifactId()));
        }
        projectInfo.setCoordinates(this.extractCoordinates(project));
        if (project.hasParent()) {
            projectInfo.setParentCoordinates(this.extractCoordinates(project.getParent()));
        }
        try {
            projectInfo.getDependencies().addAll(this.collectDependencyStructure(project));
        }
        catch (DependencyResolutionException e) {
            if (this.ignoreDependencyResolutionErrors) {
                this.warn("Skipping project " + project.getArtifactId() + ", error resolving dependencies (ignoreDependencyResolutionErrors=true)");
                this.warn("------------------------------------------------------");
                this.warn(e.getMessage());
                this.warn("------------------------------------------------------");
                projectInfo = null;
            }
            this.error("Error resolving dependencies for project " + project.getArtifactId() + ", exiting");
            throw e;
        }
        this.debug("Total Processing Time = " + (System.currentTimeMillis() - startTime) + " [msec]");
        return projectInfo;
    }

    protected Collection<DependencyInfo> collectDependencyStructure(MavenProject project) throws DependencyResolutionException {
        AetherDependencyNode rootNode = DependencyGraphFactory.getAetherDependencyGraphRootNode((MavenProject)project, (ProjectDependenciesResolver)this.projectDependenciesResolver, (MavenSession)this.session);
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        for (AetherDependencyNode dependencyNode : rootNode.getChildren()) {
            String scope = dependencyNode.getDependency().getScope();
            if (!StringUtils.isBlank((String)scope) && this.shouldIgnore(scope)) continue;
            DependencyInfo info = this.getDependencyInfo(dependencyNode);
            dependencyInfos.add(info);
        }
        this.debug(MessageFormat.format("*** Printing Graph Result for {0} ***", project.getName()));
        for (DependencyInfo dependencyInfo : dependencyInfos) {
            this.debugPrintChildren(dependencyInfo, "");
        }
        return dependencyInfos;
    }

    private void debugPrintChildren(DependencyInfo info, String prefix) {
        this.debug(prefix + info.getGroupId() + ":" + info.getArtifactId() + ":" + info.getVersion() + ":" + info.getScope());
        for (DependencyInfo child : info.getChildren()) {
            this.debugPrintChildren(child, prefix + "   ");
        }
    }

    protected Coordinates extractCoordinates(MavenProject mavenProject) {
        return new Coordinates(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    protected boolean matchAny(String value, String[] patterns) {
        if (value == null) {
            return false;
        }
        boolean match = false;
        for (int i = 0; i < patterns.length && !match; ++i) {
            String pattern = patterns[i];
            if (pattern == null) continue;
            String regex = pattern.replace(".", "\\.").replace("*", ".*");
            match = value.matches(regex);
        }
        return match;
    }

    protected Collection<AgentProjectInfo> extractProjectInfos() throws MojoExecutionException, DependencyResolutionException {
        ArrayList<AgentProjectInfo> projectInfos = new ArrayList<AgentProjectInfo>();
        for (MavenProject project : this.reactorProjects) {
            AgentProjectInfo projectInfo;
            if (!this.shouldProcess(project) || (projectInfo = this.processProject(project)) == null) continue;
            projectInfos.add(projectInfo);
        }
        this.debugProjectInfos(projectInfos);
        if (StringUtils.isBlank((String)this.aggregateProjectName)) {
            this.aggregateProjectName = this.mavenProject.getArtifactId() + DASH + this.mavenProject.getVersion();
        }
        return projectInfos;
    }

    private Collection<DependencyInfo> extractChildren(DependencyInfo dependency) {
        ArrayList<DependencyInfo> children = new ArrayList<DependencyInfo>();
        Iterator iterator = dependency.getChildren().iterator();
        while (iterator.hasNext()) {
            DependencyInfo child = (DependencyInfo)iterator.next();
            children.add(child);
            children.addAll(this.extractChildren(child));
            iterator.remove();
        }
        return children;
    }

    protected boolean shouldProcess(MavenProject project) {
        if (project == null) {
            return false;
        }
        boolean process = true;
        if (this.ignorePomModules && POM.equals(project.getPackaging())) {
            process = false;
            this.info("Skipping " + project.getId() + " (ignorePomModules=" + String.valueOf(this.ignorePomModules) + ")");
        } else if (project.equals((Object)this.mavenProject)) {
            boolean bl = process = !this.ignore;
            if (!process) {
                this.info("Skipping " + project.getId() + " (marked as ignored)");
            }
        } else if (this.excludes.length > 0) {
            boolean bl = process = !this.matchAny(project.getArtifactId(), this.excludes);
            if (!process) {
                this.info("Skipping " + project.getId() + " (marked as excluded)");
            }
        } else if (this.includes.length > 0 && !(process = this.matchAny(project.getArtifactId(), this.includes))) {
            this.info("Skipping " + project.getId() + " (not marked as included)");
        }
        return process;
    }

    protected void generateReport(BaseCheckPoliciesResult result) throws MojoExecutionException {
        this.info("Generating Policy Check Report");
        try {
            PolicyCheckReport report = new PolicyCheckReport(result);
            report.generate(this.outputDirectory, false);
            report.generateJson(this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating report: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean shouldIgnore(String scope) {
        boolean ignore = false;
        for (String ignoredScope : this.ignoredScopes) {
            if (!ignoredScope.equals(scope)) continue;
            ignore = true;
            break;
        }
        return ignore;
    }

    private String getFilename(AetherArtifact artifact) {
        return MessageFormat.format(FILENAME_PATTERN, artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension());
    }
}

