/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionException;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.maven.AgentMojo;

@Mojo(name="update", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class UpdateMojo
extends AgentMojo {
    public static final String POLICY_VIOLATIONS_FOUND = "Some dependencies were rejected by the organization's policies";
    public static final String NO_POLICY_VIOLATIONS = "All dependencies conform with the organization's policies";
    public static final String SENDING_FORCE_UPDATE = "Force Update Enabled, Sending Update Request to WhiteSource";
    public static final String SENDING_UPDATE = "Sending Update Request to WhiteSource";
    @Parameter(alias="checkPolicies", property="org.whitesource.checkPolicies", required=false, defaultValue="false")
    private boolean checkPolicies;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException, DependencyResolutionException {
        if (this.reactorProjects == null) {
            this.info("No Projects Found. Skipping Update");
            return;
        }
        this.init();
        Collection<AgentProjectInfo> projectInfos = this.extractProjectInfos();
        this.removeEmptyProjects(projectInfos);
        if (projectInfos.isEmpty()) {
            this.info("No open source information found.");
        } else {
            this.sendUpdate(projectInfos);
        }
    }

    @Override
    protected void init() throws MojoFailureException {
        super.init();
        Properties systemProperties = this.session.getSystemProperties();
        this.checkPolicies = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.checkPolicies", Boolean.toString(this.checkPolicies)));
    }

    private void sendUpdate(Collection<AgentProjectInfo> projectInfos) throws MojoFailureException, MojoExecutionException {
        try {
            if (this.checkPolicies) {
                this.info("Checking Policies");
                CheckPolicyComplianceResult result = this.service.checkPolicyCompliance(this.orgToken, this.product, this.productVersion, projectInfos, this.forceCheckAllDependencies, this.userKey, this.requesterEmail, Boolean.valueOf(this.aggregateModules), Boolean.valueOf(this.preserveModuleInfo), this.aggregateProjectName, this.aggregateProjectToken);
                if (this.outputDirectory == null || !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                    this.warn("Output directory doesn't exist. Skipping policies check report.");
                } else {
                    this.generateReport((BaseCheckPoliciesResult)result);
                }
                boolean hasRejections = result.hasRejections();
                if (!hasRejections) {
                    this.info(NO_POLICY_VIOLATIONS);
                }
                if (!hasRejections || this.forceUpdate) {
                    this.info(this.forceUpdate ? SENDING_FORCE_UPDATE : SENDING_UPDATE);
                    UpdateInventoryResult updateResult = this.service.update(this.orgToken, this.requesterEmail, this.product, this.productVersion, projectInfos, this.userKey, this.aggregateModules, this.preserveModuleInfo, this.aggregateProjectName, this.aggregateProjectToken);
                    this.logResult(updateResult);
                }
                if (hasRejections) {
                    throw new MojoExecutionException(POLICY_VIOLATIONS_FOUND);
                }
            } else {
                this.info(SENDING_UPDATE);
                UpdateInventoryResult updateResult = this.service.update(this.orgToken, this.requesterEmail, this.product, this.productVersion, projectInfos, this.userKey, this.aggregateModules, this.preserveModuleInfo, this.aggregateProjectName, this.aggregateProjectToken);
                this.logResult(updateResult);
            }
        }
        catch (WssServiceException e) {
            if (this.isConnectionError((Exception)((Object)e))) {
                if (this.connectionRetries-- > 0) {
                    this.info("Attempting to reconnect to WhiteSource");
                    try {
                        Thread.sleep(this.connectionRetryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.sendUpdate(projectInfos);
                }
                throw new MojoExecutionException("Error communicating with service: Connection refused: ", (Exception)((Object)e));
            }
            throw new MojoExecutionException("Error communicating with service: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void logResult(UpdateInventoryResult result) {
        this.info("");
        this.info("------------------------------------------------------------------------");
        this.info("Inventory Update Result for " + result.getOrganization());
        this.info("------------------------------------------------------------------------");
        Collection createdProjects = result.getCreatedProjects();
        if (!createdProjects.isEmpty()) {
            this.info("");
            this.info("Newly Created Projects:");
            for (Object projectName : createdProjects) {
                this.info("* " + (String)projectName);
            }
        }
        Collection updatedProjects = result.getUpdatedProjects();
        if (!updatedProjects.isEmpty()) {
            this.info("");
            this.info("Updated Projects:");
            for (String projectName : updatedProjects) {
                this.info("* " + projectName);
            }
        }
        String requestToken = result.getRequestToken();
        if (StringUtils.isNotBlank((String)requestToken)) {
            this.info("");
            this.info("Support Token: " + requestToken);
        } else {
            this.info("");
        }
    }

    private void removeEmptyProjects(Collection<AgentProjectInfo> projectInfos) {
        ArrayList<AgentProjectInfo> emptyProjects = new ArrayList<AgentProjectInfo>();
        if (!this.updateEmptyProject) {
            for (AgentProjectInfo child : projectInfos) {
                if (child.getDependencies().size() != 0) continue;
                emptyProjects.add(child);
            }
        }
        projectInfos.removeAll(emptyProjects);
    }
}

