/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.client;

import java.util.Collection;
import java.util.Map;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesResult;
import org.whitesource.agent.api.dispatch.ConfigurationResult;
import org.whitesource.agent.api.dispatch.GetDependencyDataResult;
import org.whitesource.agent.api.dispatch.RequestFactory;
import org.whitesource.agent.api.dispatch.SummaryScanResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.dispatch.UpdateType;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WssServiceClient;
import org.whitesource.agent.client.WssServiceClientImpl;
import org.whitesource.agent.client.WssServiceException;

public class WhitesourceService {
    private WssServiceClient client;
    private RequestFactory requestFactory;

    public WhitesourceService() {
        this("generic", "1.0", "1.0");
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion) {
        this(agent, agentVersion, pluginVersion, null);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl) {
        this(agent, agentVersion, pluginVersion, serviceUrl, true);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy) {
        this(agent, agentVersion, pluginVersion, serviceUrl, setProxy, 60);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(agent, agentVersion, pluginVersion, serviceUrl, setProxy, connectionTimeoutMinutes, false);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes, boolean ignoreCertificateCheck) {
        this.requestFactory = new RequestFactory(agent, agentVersion, pluginVersion);
        String url = serviceUrl;
        if (url == null || url.trim().length() == 0) {
            url = System.getProperty("wss.url", "https://saas.whitesourcesoftware.com/agent");
        }
        if (connectionTimeoutMinutes <= 0) {
            connectionTimeoutMinutes = Integer.parseInt(System.getProperty("wss.connectionTimeoutMinutes", String.valueOf(60)));
        }
        this.client = new WssServiceClientImpl(url, setProxy, connectionTimeoutMinutes, ignoreCertificateCheck);
    }

    public WhitesourceService(String agent, String agentVersion, String serviceUrl, boolean setProxy) {
        this(agent, agentVersion, serviceUrl, setProxy, 60);
    }

    public WhitesourceService(String agent, String agentVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(agent, agentVersion, null, serviceUrl, setProxy, connectionTimeoutMinutes);
    }

    public UpdateInventoryResult update(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.update(orgToken, null, product, productVersion, projectInfos, userKey);
    }

    public UpdateInventoryResult update(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, null, product, productVersion, projectInfos, null);
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, Map<String, String> extraProperties) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, extraProperties));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, requesterEmail, product, productVersion, projectInfos, null);
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, null));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData, scanComment));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment, String productToken, Map<String, String> extraProperties) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData, scanComment, productToken, extraProperties));
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment, String productToken) throws WssServiceException {
        return this.update(orgToken, requesterEmail, updateType, product, productVersion, projectInfos, userKey, logData, scanComment, productToken, null);
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, requesterEmail, updateType, product, productVersion, projectInfos, null);
    }

    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, boolean aggregateModules, boolean preserveModuleStructure, String aggregateProjectName, String aggregateProjectToken) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, Boolean.valueOf(aggregateModules), Boolean.valueOf(preserveModuleStructure), aggregateProjectName, aggregateProjectToken));
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String scanComment, String productToken) {
        return this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, scanComment, productToken);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String scanComment) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, userKey, requesterEmail, scanComment, null);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, userKey, null, null);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, null);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) {
        return this.offlineUpdate(orgToken, product, false, productVersion, projectInfos, null, null, null);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String scanComment) {
        return this.offlineUpdate(orgToken, product, false, productVersion, projectInfos, null, null, scanComment);
    }

    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) {
        return this.offlineUpdate(orgToken, product, productVersion, projectInfos, null);
    }

    public CheckPoliciesResult checkPolicies(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.client.checkPolicies(this.requestFactory.newCheckPoliciesRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail));
    }

    public CheckPoliciesResult checkPolicies(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.checkPolicies(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, String logData, String productToken) throws WssServiceException {
        return this.client.checkPolicyCompliance(this.requestFactory.newCheckPolicyComplianceRequest(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, logData, productToken));
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, String logData) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, logData, null);
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, null);
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, null);
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, null);
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, Boolean aggregateModules, Boolean preserveModuleStructure, String aggregateProjectName, String aggregateProjectToken) throws WssServiceException {
        return this.client.checkPolicyCompliance(this.requestFactory.newCheckPolicyComplianceRequest(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, aggregateModules.booleanValue(), preserveModuleStructure.booleanValue(), aggregateProjectName, aggregateProjectToken));
    }

    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.getDependencyData(this.requestFactory.newDependencyDataRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, null);
    }

    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.summaryScan(this.requestFactory.newSummaryScanRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, null);
    }

    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.checkVulnerabilities(this.requestFactory.newCheckVulnerabilitiesRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, null);
    }

    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.getConfiguration(this.requestFactory.newConfigurationRequest(orgToken, product, productVersion, userKey, requesterEmail, productToken));
    }

    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey, String requesterEmail) throws WssServiceException {
        return this.getConfiguration(orgToken, product, productVersion, userKey, requesterEmail, null);
    }

    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey) throws WssServiceException {
        return this.client.getConfiguration(this.requestFactory.newConfigurationRequest(orgToken, product, productVersion, userKey));
    }

    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion) throws WssServiceException {
        return this.getConfiguration(orgToken, product, productVersion, null);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public WssServiceClient getClient() {
        return this.client;
    }

    public void setClient(WssServiceClient client) {
        this.client = client;
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

