/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.whitesource.agent.api.model.RequestPolicyInfo;
import org.whitesource.agent.api.model.ResourceInfo;

public class PolicyCheckResourceNode
implements Serializable {
    private static final long serialVersionUID = -3206810244665473L;
    private ResourceInfo resource;
    private RequestPolicyInfo policy;
    private Collection<PolicyCheckResourceNode> children = new ArrayList<PolicyCheckResourceNode>();

    public PolicyCheckResourceNode() {
    }

    public PolicyCheckResourceNode(ResourceInfo resource, RequestPolicyInfo policy) {
        this();
        this.resource = resource;
        this.policy = policy;
    }

    public boolean hasRejections() {
        boolean rejections = this.policy != null && "Reject".equals(this.policy.getActionType());
        Iterator<PolicyCheckResourceNode> it = this.children.iterator();
        while (it.hasNext() && !rejections) {
            rejections = it.next().hasRejections();
        }
        return rejections;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    public RequestPolicyInfo getPolicy() {
        return this.policy;
    }

    public void setPolicy(RequestPolicyInfo policy) {
        this.policy = policy;
    }

    public Collection<PolicyCheckResourceNode> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<PolicyCheckResourceNode> children) {
        this.children = children;
    }
}

