/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.hash;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.hash.FileExtensions;
import org.whitesource.agent.hash.FileHandler;
import org.whitesource.agent.hash.FileUtils;
import org.whitesource.agent.hash.HashAlgorithm;
import org.whitesource.agent.hash.HashCalculationResult;
import org.whitesource.agent.hash.HashCalculator;

public final class ChecksumUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChecksumUtils.class);
    private static final int PARTIAL_SHA1_LINES = 100;
    private static final String EMPTY_FILE_SHA1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709";

    private ChecksumUtils() {
    }

    public static String calculateSHA1(File resourceFile) throws IOException {
        return ChecksumUtils.calculateHash(resourceFile, HashAlgorithm.SHA1);
    }

    public static String calculateHash(File resourceFile, HashAlgorithm algorithm) throws IOException {
        return new HashCalculator().calculateHash(resourceFile, algorithm);
    }

    public static void calculateHeaderAndFooterSha1(File file, DependencyInfo dependencyInfo) {
        try {
            int lines = org.apache.commons.io.FileUtils.readLines((File)file).size();
            if (lines > 100) {
                int i = (int)(Math.log((double)lines / 100.0) / Math.log(2.0));
                int linesToRead = (int)(50.0 * Math.pow(2.0, i));
                StringBuilder header = new StringBuilder();
                StringBuilder footer = new StringBuilder();
                int lineIndex = 0;
                for (String line : org.apache.commons.io.FileUtils.readLines((File)file)) {
                    if (lineIndex < linesToRead) {
                        header.append(line);
                    }
                    if (lineIndex >= lines - linesToRead) {
                        footer.append(line);
                    }
                    ++lineIndex;
                }
                dependencyInfo.setHeaderSha1(DigestUtils.sha1Hex((String)header.toString()));
                dependencyInfo.setFooterSha1(DigestUtils.sha1Hex((String)footer.toString()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void calculateSuperHash(DependencyInfo dependencyInfo, File dependencyFile) {
        StringBuilder superHash = new StringBuilder("");
        HashCalculator superHashCalculator = new HashCalculator();
        if (dependencyFile.getName().toLowerCase().matches(FileExtensions.SOURCE_FILE_PATTERN) || dependencyFile.getName().toLowerCase().endsWith("++")) {
            try {
                HashCalculationResult superHashResult = superHashCalculator.calculateSuperHash(dependencyFile);
                if (superHashResult != null) {
                    dependencyInfo.setFullHash(superHashResult.getFullHash());
                    dependencyInfo.setMostSigBitsHash(superHashResult.getMostSigBitsHash());
                    dependencyInfo.setLeastSigBitsHash(superHashResult.getLeastSigBitsHash());
                    superHash.append(superHashResult.getFullHash());
                }
            }
            catch (IOException e) {
                logger.warn("Error calculating fullHash for {}, Error - ", (Object)dependencyFile.getName(), (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateOtherPlatformSha1(File file) {
        String otherPlatformSha1 = null;
        if (file.length() <= 0xA00000L) {
            File otherPlatformFile = null;
            try {
                otherPlatformFile = FileUtils.createOtherPlatformFile(file);
                if (otherPlatformFile != null && EMPTY_FILE_SHA1.equals(otherPlatformSha1 = ChecksumUtils.calculateSHA1(otherPlatformFile))) {
                    otherPlatformSha1 = null;
                }
            }
            catch (Exception exception) {
            }
            finally {
                FileHandler.deleteTempFoldersHelper(FileHandler.PATH_TO_PLATFORM_DEPENDENT_TMP_DIR);
            }
        }
        return otherPlatformSha1;
    }

    public static void calculateOtherPlatformSha1(DependencyInfo dependency, File file) {
        String otherPlatformSha1 = ChecksumUtils.calculateOtherPlatformSha1(file);
        dependency.setOtherPlatformSha1(otherPlatformSha1);
    }

    private static void deleteFile(File file) {
        if (file != null) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

