/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.hash;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.boris.pecoff4j.PE;
import org.boris.pecoff4j.ResourceDirectory;
import org.boris.pecoff4j.ResourceEntry;
import org.boris.pecoff4j.io.PEParser;
import org.boris.pecoff4j.io.ResourceParser;
import org.boris.pecoff4j.resources.StringFileInfo;
import org.boris.pecoff4j.resources.StringTable;
import org.boris.pecoff4j.resources.VersionInfo;
import org.boris.pecoff4j.util.ResourceHelper;
import org.whitesource.agent.api.model.DependencyHintsInfo;

public final class HintUtils {
    private static final Logger logger = Logger.getLogger(HintUtils.class.getName());
    private static final String PORTABLE_EXECUTABLES_PATTERN = ".*\\.dll|.*\\.exe|.*\\.msi";
    private static final String COMMA_SPLIT = ",";
    private static final String EQUAL_SPLIT = "=";
    private static final String AUTH_CODE_SIGNATURE_ISSUER_PATTERN = "(Get-AuthenticodeSignature {0}).SignerCertificate.IssuerName";
    private static final String AUTH_CODE_SIGNATURE_SUBJECT_PATTERN = "(Get-AuthenticodeSignature {0}).SignerCertificate.Subject";
    private static final String POWER_SHELL = "powershell.exe";
    private static final String POWER_SHELL_COMMAND = "-Command";
    private static final String COMPANY_NAME = "CompanyName";
    private static final String FILE_VERSION = "FileVersion";
    private static final String COPYRIGHT = "LegalCopyright";
    private static final String ORIGINAL_FILE_NAME = "OriginalFilename";
    private static final String PRODUCT_NAME = "ProductName";
    private static final String PRODUCT_VERSION = "ProductVersion";
    private static final String MISSING_VALUE = "N/A";
    private static final String COMMON_NAME_PARAMETER = "CN";

    private HintUtils() {
    }

    public static DependencyHintsInfo getHints(String filename) {
        DependencyHintsInfo hints = null;
        if (StringUtils.isNotBlank((String)filename) && filename.matches(PORTABLE_EXECUTABLES_PATTERN)) {
            hints = HintUtils.getPortableExecutableHints(filename);
        }
        return hints;
    }

    private static DependencyHintsInfo getPortableExecutableHints(String filename) {
        DependencyHintsInfo hints = null;
        try {
            PE pe = PEParser.parse((String)filename);
            ResourceDirectory rd = pe.getImageData().getResourceTable();
            ResourceEntry[] entries = ResourceHelper.findResources((ResourceDirectory)rd, (int)16);
            byte[] data = entries[0].getData();
            VersionInfo version = ResourceParser.readVersionInfo((byte[])data);
            StringFileInfo stringFileInfo = version.getStringFileInfo();
            StringTable table = stringFileInfo.getTable(0);
            hints = new DependencyHintsInfo();
            block18: for (int i = 0; i < table.getCount(); ++i) {
                String value = table.getString(i).getValue();
                if (!StringUtils.isNotBlank((String)value) || value.equals(MISSING_VALUE)) continue;
                switch (table.getString(i).getKey()) {
                    case "CompanyName": {
                        hints.setCompanyName(value);
                        continue block18;
                    }
                    case "FileVersion": {
                        hints.setFileVersion(value);
                        continue block18;
                    }
                    case "LegalCopyright": {
                        hints.setCopyright(value);
                        continue block18;
                    }
                    case "OriginalFilename": {
                        hints.setOriginalFilename(value);
                        continue block18;
                    }
                    case "ProductName": {
                        hints.setProductName(value);
                        continue block18;
                    }
                    case "ProductVersion": {
                        hints.setProductVersion(value);
                        continue block18;
                    }
                }
            }
            if (Platform.isWindows()) {
                hints.setIssuerCommonName(HintUtils.executePowerShellCommand(MessageFormat.format(AUTH_CODE_SIGNATURE_ISSUER_PATTERN, filename)));
                hints.setSubjectCommonName(HintUtils.executePowerShellCommand(MessageFormat.format(AUTH_CODE_SIGNATURE_SUBJECT_PATTERN, filename)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hints;
    }

    private static String executePowerShellCommand(String command) {
        try {
            String line;
            String[] commandList = new String[]{POWER_SHELL, POWER_SHELL_COMMAND, command};
            ProcessBuilder pb = new ProcessBuilder(commandList);
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(COMMON_NAME_PARAMETER)) continue;
                String[] values = line.split(COMMA_SPLIT);
                return values[0].substring(values[0].indexOf(EQUAL_SPLIT) + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

