/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Comment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.parser.ParseResult;

public class JavaScriptParser {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptParser.class);
    private static final String EMPTY_STRING = "";
    private static final String COMMENT_REGEX = "(/\\*[\\s\\S]*?\\*/)";

    public ParseResult parse(String fileContent) {
        ParseResult result = null;
        CompilerEnvirons environment = new CompilerEnvirons();
        environment.setLanguageVersion(180);
        environment.setStrictMode(false);
        environment.setRecordingComments(true);
        environment.setAllowSharpComments(true);
        environment.setRecordingLocalJsDocComments(true);
        Parser parser = new Parser(environment);
        try {
            AstRoot root = parser.parse((Reader)new StringReader(fileContent), null, 1);
            result = new ParseResult();
            result.setContentWithoutComments(root.toSource());
            SortedSet comments = root.getComments();
            if (comments != null && !comments.isEmpty()) {
                String headerlessFileContent = this.removeHeaderComments(fileContent, comments);
                result.setContentWithoutHeaderComments(headerlessFileContent);
            }
        }
        catch (Exception e) {
            logger.debug("Error parsing JavaScript file: {}", (Object)e.getMessage());
        }
        return result;
    }

    private String removeHeaderComments(String fileContent, SortedSet<Comment> comments) {
        Comment comment;
        String commentValue;
        String headerlessFileContent = fileContent;
        Iterator iterator = comments.iterator();
        while (iterator.hasNext() && headerlessFileContent.startsWith(commentValue = (comment = (Comment)iterator.next()).getValue())) {
            headerlessFileContent = headerlessFileContent.replace(commentValue, EMPTY_STRING);
            while (StringUtils.isNotBlank((String)headerlessFileContent) && Character.isWhitespace(headerlessFileContent.charAt(0))) {
                headerlessFileContent = headerlessFileContent.substring(1);
            }
        }
        return headerlessFileContent;
    }
}

