/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.model.PolicyCheckResourceNode;
import org.whitesource.agent.api.model.RequestPolicyInfo;
import org.whitesource.agent.api.model.ResourceInfo;
import org.whitesource.agent.report.FileUtils;
import org.whitesource.agent.report.model.LicenseHistogramDataPoint;
import org.whitesource.agent.report.summary.PolicyRejectionReport;
import org.whitesource.agent.report.summary.RejectedLibrary;
import org.whitesource.agent.report.summary.RejectingPolicy;

public class PolicyCheckReport {
    private static final String TEMPLATE_FOLDER = "templates/";
    private static final String TEMPLATE_FILE = "policy-check.vm";
    private static final String CSS_FILE = "wss.css";
    private static final float MAX_BAR_HEIGHT = 50.0f;
    private static final int LICENSE_LIMIT = 6;
    private static final String OTHER_LICENSE = "Other types";
    public static final String REJECT = "Reject";
    public static final String CHECK_POLICIES_JSON_FILE = "checkPolicies-json.txt";
    public static final String POLICY_REJECTION_SUMMARY_FILE = "policyRejectionSummary.json";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private BaseCheckPoliciesResult result;
    private String buildName;
    private String buildNumber;

    public PolicyCheckReport(BaseCheckPoliciesResult result) {
        this.result = result;
    }

    public PolicyCheckReport(BaseCheckPoliciesResult result, String buildName, String buildNumber) {
        this(result);
        this.buildName = buildName;
        this.buildNumber = buildNumber;
    }

    public File generate(File outputDir, boolean pack) throws IOException {
        return this.generate(outputDir, pack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(File outputDir, boolean pack, Properties properties) throws IOException {
        File workDir;
        if (this.result == null) {
            throw new IllegalStateException("Check policies result is null");
        }
        File reportFile = workDir = new File(outputDir, "whitesource");
        if (!workDir.exists() && !workDir.mkdir()) {
            throw new IOException("Unable to make output directory: " + workDir);
        }
        VelocityEngine engine = this.createTemplateEngine(properties);
        VelocityContext context = this.createTemplateContext();
        FileWriter fw = new FileWriter(new File(workDir, "index.html"));
        try {
            engine.mergeTemplate("templates/policy-check.vm", "UTF-8", (Context)context, (Writer)fw);
            fw.flush();
        }
        finally {
            FileUtils.close(fw);
        }
        this.copyReportResources(workDir);
        if (pack) {
            reportFile = new File(outputDir, "whitesource.zip");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(reportFile));
            FileUtils.packDirectory(workDir, zos);
            FileUtils.deleteRecursive(workDir);
        }
        return reportFile;
    }

    public File generateJson(File outputDir) throws IOException {
        if (this.result == null) {
            throw new IllegalStateException("Check policies result is null");
        }
        File workDir = new File(outputDir, "whitesource");
        if (!workDir.exists() && !workDir.mkdir()) {
            throw new IOException("Unable to make output directory: " + workDir);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        this.writeToFile(new File(workDir, CHECK_POLICIES_JSON_FILE), gson.toJson((Object)this.result));
        HashMap<RequestPolicyInfo, RejectingPolicy> policyToSummaryMap = new HashMap<RequestPolicyInfo, RejectingPolicy>();
        for (Map.Entry entry : this.result.getExistingProjects().entrySet()) {
            this.updatePolicyRejectionSummary((PolicyCheckResourceNode)entry.getValue(), (String)entry.getKey(), policyToSummaryMap);
        }
        for (Map.Entry entry : this.result.getNewProjects().entrySet()) {
            this.updatePolicyRejectionSummary((PolicyCheckResourceNode)entry.getValue(), (String)entry.getKey(), policyToSummaryMap);
        }
        PolicyRejectionReport report = new PolicyRejectionReport();
        for (RejectingPolicy rejectingPolicy : policyToSummaryMap.values()) {
            report.getRejectingPolicies().add(rejectingPolicy);
            report.getSummary().setTotalRejectedLibraries(report.getSummary().getTotalRejectedLibraries() + rejectingPolicy.getRejectedLibraries().size());
        }
        this.writeToFile(new File(workDir, POLICY_REJECTION_SUMMARY_FILE), gson.toJson((Object)report));
        return workDir;
    }

    protected VelocityEngine createTemplateEngine(Properties properties) {
        String loggerClass;
        String resourceLoader;
        Properties actualProperties = properties;
        if (actualProperties == null) {
            actualProperties = new Properties();
        }
        if (StringUtils.isBlank((String)(resourceLoader = actualProperties.getProperty("resource.loader")))) {
            actualProperties.setProperty("resource.loader", "classpath");
            actualProperties.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        }
        if (StringUtils.isBlank((String)(loggerClass = actualProperties.getProperty("runtime.log.logsystem.class")))) {
            actualProperties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
        }
        VelocityEngine velocity = new VelocityEngine(actualProperties);
        velocity.init();
        return velocity;
    }

    protected VelocityContext createTemplateContext() {
        VelocityContext context = new VelocityContext();
        context.put("result", (Object)this.result);
        context.put("hasRejections", (Object)this.result.hasRejections());
        context.put("licenses", this.createLicenseHistogram(this.result));
        context.put("creationTime", (Object)new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        if (StringUtils.isNotBlank((String)this.buildName)) {
            context.put("buildName", (Object)this.buildName);
        }
        if (StringUtils.isNotBlank((String)this.buildNumber)) {
            context.put("buildNumber", (Object)this.buildNumber);
        }
        return context;
    }

    protected void copyReportResources(File workDir) throws IOException {
        FileUtils.copyResource("templates/wss.css", new File(workDir, CSS_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(File file, String json) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(StringEscapeUtils.unescapeJava((String)json));
            fw.flush();
        }
        finally {
            FileUtils.close(fw);
        }
    }

    private Collection<LicenseHistogramDataPoint> createLicenseHistogram(BaseCheckPoliciesResult result) {
        ArrayList<LicenseHistogramDataPoint> dataPoints = new ArrayList<LicenseHistogramDataPoint>();
        HashMap<String, Integer> licenseHistogram = new HashMap<String, Integer>();
        for (Map.Entry entry : result.getProjectNewResources().entrySet()) {
            for (Object resource : (Collection)entry.getValue()) {
                for (String license : resource.getLicenses()) {
                    licenseHistogram.put(license, MapUtils.getInteger(licenseHistogram, (Object)license, (Integer)0) + 1);
                }
            }
        }
        ArrayList licenses = new ArrayList(licenseHistogram.entrySet());
        Collections.sort(licenses, new ValueComparator());
        if (!licenses.isEmpty()) {
            for (Map.Entry entry : licenses.subList(0, Math.min(6, licenses.size()))) {
                dataPoints.add(new LicenseHistogramDataPoint((String)entry.getKey(), (Integer)entry.getValue()));
            }
            int n = licenses.size() - 6;
            int tailSum = 0;
            if (n > 0) {
                for (Map.Entry entry : licenses.subList(6, licenses.size())) {
                    tailSum += ((Integer)entry.getValue()).intValue();
                }
                dataPoints.add(new LicenseHistogramDataPoint("Other types (" + n + ")", tailSum));
            }
            float factor = 50.0f / (float)Math.max(tailSum, (Integer)((Map.Entry)licenses.get(0)).getValue());
            for (LicenseHistogramDataPoint dataPoint : dataPoints) {
                dataPoint.setHeight((int)(factor * (float)dataPoint.getOccurrences()));
            }
        }
        return dataPoints;
    }

    private void updatePolicyRejectionSummary(PolicyCheckResourceNode node, String projectName, Map<RequestPolicyInfo, RejectingPolicy> policyResourceMap) {
        RequestPolicyInfo policy = node.getPolicy();
        if (policy != null && policy.getActionType().equals(REJECT)) {
            ResourceInfo resource;
            RejectedLibrary rejectedLibrary;
            Set<RejectedLibrary> rejectedResources;
            RejectingPolicy rejectingPolicy = policyResourceMap.get(policy);
            if (rejectingPolicy == null) {
                rejectingPolicy = new RejectingPolicy(policy.getDisplayName(), policy.getFilterType(), policy.isProjectLevel(), policy.isInclusive());
                policyResourceMap.put(policy, rejectingPolicy);
            }
            if ((rejectedResources = rejectingPolicy.getRejectedLibraries()).contains(rejectedLibrary = new RejectedLibrary((resource = node.getResource()).getDisplayName(), resource.getSha1(), resource.getLink()))) {
                for (RejectedLibrary summary : rejectedResources) {
                    if (!rejectedLibrary.equals(summary)) continue;
                    summary.getProjects().add(projectName);
                    break;
                }
            } else {
                rejectedLibrary.getProjects().add(projectName);
                rejectedResources.add(rejectedLibrary);
            }
        }
        for (PolicyCheckResourceNode childNode : node.getChildren()) {
            this.updatePolicyRejectionSummary(childNode, projectName, policyResourceMap);
        }
    }

    public BaseCheckPoliciesResult getResult() {
        return this.result;
    }

    public void setResult(BaseCheckPoliciesResult result) {
        this.result = result;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    static class ValueComparator
    implements Comparator<Map.Entry<String, Integer>>,
    Serializable {
        private static final long serialVersionUID = 2134689708073092860L;

        ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
            return o2.getValue().compareTo(o1.getValue());
        }
    }
}

