/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.server.LocalSingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;
import org.wildfly.service.ServiceDependency;

public class LocalSingletonServiceTarget
extends DelegatingServiceTarget
implements SingletonServiceTarget {
    private final ServiceDependency<GroupMember> member;
    private final Function<ServiceBuilder<?>, Consumer<Singleton>> singletonFactory;

    public LocalSingletonServiceTarget(ServiceTarget target, ServiceDependency<GroupMember> member, Function<ServiceBuilder<?>, Consumer<Singleton>> singletonFactory) {
        super(target);
        this.member = member;
        this.singletonFactory = singletonFactory;
    }

    public SingletonServiceBuilder<?> addService() {
        return new LocalSingletonServiceBuilder(this.getDelegate().addService(), this.member, this.singletonFactory);
    }

    @Deprecated
    public SingletonServiceBuilder<?> addService(ServiceName name) {
        return new LocalSingletonServiceBuilder(this.getDelegate().addService(name), this.member, this.singletonFactory);
    }

    @Deprecated
    public <T> SingletonServiceBuilder<T> addService(ServiceName name, Service<T> service) {
        return new LocalSingletonServiceBuilder(this.getDelegate().addService(name, service), this.member, this.singletonFactory);
    }

    public SingletonServiceTarget subTarget() {
        return new LocalSingletonServiceTarget(this.getDelegate().subTarget(), this.member, this.singletonFactory);
    }
}

