/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ApplicationContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName applicationContextServiceName = ContextNames.contextServiceNameOfApplication((String)moduleDescription.getApplicationName());
        NamingStoreService contextService = new NamingStoreService(true);
        serviceTarget.addService(applicationContextServiceName, (Service)contextService).install();
        ServiceName appNameServiceName = applicationContextServiceName.append(new String[]{"AppName"});
        BinderService applicationNameBinder = new BinderService("AppName");
        applicationNameBinder.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Object)moduleDescription.getApplicationName()));
        serviceTarget.addService(appNameServiceName, (Service)applicationNameBinder).addDependency(applicationContextServiceName, ServiceBasedNamingStore.class, (Injector)applicationNameBinder.getNamingStoreInjector()).install();
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES, (Object)appNameServiceName);
        deploymentUnit.putAttachment(Attachments.APPLICATION_CONTEXT_CONFIG, (Object)applicationContextServiceName);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.APPLICATION_CONTEXT_CONFIG);
    }
}

