/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.txn.subsystem.Attribute;
import org.jboss.as.txn.subsystem.Element;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem50Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class TransactionSubsystem60Parser
extends TransactionSubsystem50Parser {
    TransactionSubsystem60Parser() {
        super(Namespace.TRANSACTIONS_6_0);
    }

    TransactionSubsystem60Parser(Namespace namespace) {
        super(namespace);
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, Element element, List<ModelNode> operations, ModelNode subsystemOperation, ModelNode logStoreOperation) throws XMLStreamException {
        switch (element) {
            case RECOVERY_ENVIRONMENT: {
                this.parseRecoveryEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case CORE_ENVIRONMENT: {
                this.parseCoreEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case COORDINATOR_ENVIRONMENT: {
                this.parseCoordinatorEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case OBJECT_STORE: {
                this.parseObjectStoreEnvironmentElementAndEnrichOperation(reader, subsystemOperation);
                break;
            }
            case JTS: {
                this.parseJts(reader, subsystemOperation);
                break;
            }
            case USE_JOURNAL_STORE: {
                if (this.choiceObjectStoreEncountered) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.choiceObjectStoreEncountered = true;
                this.parseUseJournalstore(reader, logStoreOperation, subsystemOperation);
                subsystemOperation.get("use-journal-store").set(true);
                break;
            }
            case JDBC_STORE: {
                if (this.choiceObjectStoreEncountered) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.choiceObjectStoreEncountered = true;
                this.parseJdbcStoreElementAndEnrichOperation(reader, logStoreOperation, subsystemOperation);
                subsystemOperation.get("use-jdbc-store").set(true);
                break;
            }
            case CM_RESOURCES: {
                this.parseCMs(reader, operations);
                break;
            }
            case CLIENT: {
                this.parseClient(reader, subsystemOperation);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    protected void parseClient(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.STALE_TRANSACTION_TIME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case STALE_TRANSACTION_TIME: {
                    TransactionSubsystemRootResourceDefinition.STALE_TRANSACTION_TIME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

