/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricFunction;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationFunction;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterNodeDefinition;
import org.wildfly.extension.undertow.filters.ModClusterServiceNameProvider;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

class ModClusterContextDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"context");
    static final ResourceDescriptionResolver RESOLVER = UndertowExtension.getResolver("filter", ModClusterDefinition.PATH_ELEMENT.getKey(), ModClusterBalancerDefinition.PATH_ELEMENT.getKey(), ModClusterNodeDefinition.PATH_ELEMENT.getKey(), PATH_ELEMENT.getKey());
    private final FunctionExecutorRegistry<ModCluster> registry;
    static final Function<OperationContext, Function<ModCluster, ModClusterStatus.Context>> NODE_FUNCTION_FACTORY = new Function<OperationContext, Function<ModCluster, ModClusterStatus.Context>>(){

        @Override
        public Function<ModCluster, ModClusterStatus.Context> apply(OperationContext context) {
            PathAddress contextAddress = context.getCurrentAddress();
            String contextName = contextAddress.getLastElement().getValue();
            PathAddress nodeAddress = contextAddress.getParent();
            String nodeName = nodeAddress.getLastElement().getValue();
            PathAddress balancerAddress = nodeAddress.getParent();
            String balancerName = balancerAddress.getLastElement().getValue();
            return new ContextFunction(balancerName, nodeName, contextName);
        }
    };

    ModClusterContextDefinition(FunctionExecutorRegistry<ModCluster> registry) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, RESOLVER).setRuntime());
        this.registry = registry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MetricHandler handler = new MetricHandler((MetricExecutor)new ContextMetricExecutor(new FunctionExecutorFactory(this.registry)), ContextMetric.class);
        for (ContextMetric metric : EnumSet.allOf(ContextMetric.class)) {
            resourceRegistration.registerReadOnlyAttribute(metric.getDefinition(), (OperationStepHandler)handler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        new OperationHandler((OperationExecutor)new ContextOperationExecutor(new FunctionExecutorFactory(this.registry)), ContextOperation.class).register(resourceRegistration);
    }

    static class ContextMetricExecutor
    implements MetricExecutor<ModClusterStatus.Context> {
        private final Function<OperationContext, FunctionExecutor<ModCluster>> factory;

        ContextMetricExecutor(Function<OperationContext, FunctionExecutor<ModCluster>> factory) {
            this.factory = factory;
        }

        public ModelNode execute(OperationContext context, Metric<ModClusterStatus.Context> metric) throws OperationFailedException {
            FunctionExecutor<ModCluster> executor = this.factory.apply(context);
            Function<ModCluster, ModClusterStatus.Context> mapper = NODE_FUNCTION_FACTORY.apply(context);
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new MetricFunction(mapper, metric)) : null;
        }
    }

    static class FunctionExecutorFactory
    implements Function<OperationContext, FunctionExecutor<ModCluster>> {
        private final FunctionExecutorRegistry<ModCluster> registry;

        FunctionExecutorFactory(FunctionExecutorRegistry<ModCluster> registry) {
            this.registry = registry;
        }

        @Override
        public FunctionExecutor<ModCluster> apply(OperationContext context) {
            PathAddress serviceAddress = context.getCurrentAddress().getParent().getParent().getParent();
            return this.registry.getExecutor((Object)ServiceDependency.on((ServiceName)new ModClusterServiceNameProvider(serviceAddress).getServiceName()));
        }
    }

    static enum ContextMetric implements Metric<ModClusterStatus.Context>
    {
        STATUS("status", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.Context context) {
                return new ModelNode(context.isEnabled() ? "enabled" : (context.isStopped() ? "stopped" : "disabled"));
            }
        }
        ,
        REQUESTS("requests", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Context context) {
                return new ModelNode(context.getRequests());
            }
        };

        private final AttributeDefinition definition;

        private ContextMetric(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setStorageRuntime()).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static class ContextOperationExecutor
    implements OperationExecutor<ModClusterStatus.Context> {
        private final Function<OperationContext, FunctionExecutor<ModCluster>> factory;

        ContextOperationExecutor(Function<OperationContext, FunctionExecutor<ModCluster>> factory) {
            this.factory = factory;
        }

        public ModelNode execute(OperationContext context, ModelNode op, Operation<ModClusterStatus.Context> operation) throws OperationFailedException {
            FunctionExecutor<ModCluster> executor = this.factory.apply(context);
            Function<ModCluster, ModClusterStatus.Context> mapper = NODE_FUNCTION_FACTORY.apply(context);
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new OperationFunction((ExpressionResolver)context, op, mapper, operation)) : null;
        }
    }

    static enum ContextOperation implements Operation<ModClusterStatus.Context>
    {
        ENABLE("enable", ModClusterStatus.Context::enable),
        DISABLE("disable", ModClusterStatus.Context::disable),
        STOP("stop", ModClusterStatus.Context::stop);

        private OperationDefinition definition;
        private final Consumer<ModClusterStatus.Context> operation;

        private ContextOperation(String name, Consumer<ModClusterStatus.Context> operation) {
            this.definition = SimpleOperationDefinitionBuilder.of((String)name, (ResourceDescriptionResolver)RESOLVER).setRuntimeOnly().build();
            this.operation = operation;
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterStatus.Context context) {
            this.operation.accept(context);
            return null;
        }

        public OperationDefinition getDefinition() {
            return this.definition;
        }
    }

    static class ContextFunction
    implements Function<ModCluster, ModClusterStatus.Context> {
        private final String balancerName;
        private final String nodeName;
        private final String contextName;

        ContextFunction(String balancerName, String nodeName, String contextName) {
            this.balancerName = balancerName;
            this.nodeName = nodeName;
            this.contextName = contextName;
        }

        @Override
        public ModClusterStatus.Context apply(ModCluster service) {
            ModClusterStatus.LoadBalancer balancer = service.getController().getStatus().getLoadBalancer(this.balancerName);
            ModClusterStatus.Node node = balancer != null ? balancer.getNode(this.nodeName) : null;
            return node != null ? node.getContext(this.contextName) : null;
        }
    }
}

