/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import org.jboss.as.web.session.SessionIdentifierCodec;

public class CodecSessionConfig
implements SessionConfig {
    private final SessionConfig config;
    private final SessionIdentifierCodec codec;

    public CodecSessionConfig(SessionConfig config, SessionIdentifierCodec codec) {
        this.config = config;
        this.codec = codec;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        String requestedSessionId;
        CharSequence encodedSessionId = this.codec.encode((CharSequence)sessionId);
        if (!encodedSessionId.equals(requestedSessionId = this.config.findSessionId(exchange))) {
            this.config.setSessionId(exchange, encodedSessionId.toString());
        }
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CharSequence encodedSessionId = this.codec.encode((CharSequence)sessionId);
        this.config.clearSession(exchange, encodedSessionId.toString());
    }

    public String findSessionId(HttpServerExchange exchange) {
        String requestedSessionId = this.config.findSessionId(exchange);
        return requestedSessionId != null ? this.codec.decode((CharSequence)requestedSessionId).toString() : null;
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.config.sessionCookieSource(exchange);
    }

    public String rewriteUrl(String originalUrl, String sessionId) {
        CharSequence encodedSessionId = this.codec.encode((CharSequence)sessionId);
        return this.config.rewriteUrl(originalUrl, encodedSessionId.toString());
    }
}

