/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.Date;
import javax.cache.Cache;
import javax.cache.CacheStatistics;
import javax.cache.Status;
import javax.cache.mbeans.CacheMXBean;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CacheMXBeanImpl
implements CacheMXBean {
    private final Cache cache;
    private String ownerTenantDomain;
    private int ownerTenantId;

    public CacheMXBeanImpl(Cache cache, String ownerTenantDomain, int ownerTenantId) {
        this.cache = cache;
        this.ownerTenantDomain = ownerTenantDomain;
        this.ownerTenantId = ownerTenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            this.setTenantCredentialsInCarbonContext();
            this.getCacheStatistics().clear();
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getStartAccumulationDate() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            this.setTenantCredentialsInCarbonContext();
            Date date = this.getCacheStatistics().getStartAccumulationDate();
            return date;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public long getCacheHits() {
        return this.getCacheStatistics().getCacheHits();
    }

    @Override
    public float getCacheHitPercentage() {
        return this.getCacheStatistics().getCacheHitPercentage();
    }

    @Override
    public long getCacheMisses() {
        return this.getCacheStatistics().getCacheMisses();
    }

    @Override
    public float getCacheMissPercentage() {
        return this.getCacheStatistics().getCacheMissPercentage();
    }

    @Override
    public long getCacheGets() {
        return this.getCacheStatistics().getCacheGets();
    }

    @Override
    public long getCachePuts() {
        return this.getCacheStatistics().getCachePuts();
    }

    @Override
    public long getCacheRemovals() {
        return this.getCacheStatistics().getCacheRemovals();
    }

    @Override
    public long getCacheEvictions() {
        return this.getCacheStatistics().getCacheEvictions();
    }

    @Override
    public float getAverageGetMillis() {
        return this.getCacheStatistics().getAverageGetMillis();
    }

    @Override
    public float getAveragePutMillis() {
        return this.getCacheStatistics().getAveragePutMillis();
    }

    @Override
    public float getAverageRemoveMillis() {
        return this.getCacheStatistics().getAverageRemoveMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheStatistics getCacheStatistics() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            this.setTenantCredentialsInCarbonContext();
            CacheStatistics cacheStatistics = this.cache.getStatistics();
            return cacheStatistics;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            this.setTenantCredentialsInCarbonContext();
            String string = this.cache.getName();
            return string;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getStatus() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            this.setTenantCredentialsInCarbonContext();
            Status status = this.cache.getStatus();
            return status;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void setTenantCredentialsInCarbonContext() {
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        cc.setTenantId(this.ownerTenantId);
        cc.setTenantDomain(this.ownerTenantDomain);
    }
}

