/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.context.CarbonContext;

public final class Util {
    public static void checkAccess(String ownerTenantDomain, int ownerTenantId) {
        CarbonContext carbonContext = Util.getCarbonContext();
        String callerTenantDomain = carbonContext.getTenantDomain();
        if (callerTenantDomain == null) {
            throw new IllegalStateException("Caller tenant domain cannot be null");
        }
        int callerTenantId = carbonContext.getTenantId();
        if (callerTenantId == -1) {
            throw new IllegalStateException("Caller Tenant ID cannot be -1");
        }
        if (callerTenantDomain.equals("carbon.super") && callerTenantId == -1234) {
            return;
        }
        if (!callerTenantDomain.equals(ownerTenantDomain) || callerTenantId != ownerTenantId) {
            throw new SecurityException("Illegal access attempt to cache ] owned by tenant {[" + ownerTenantDomain + "],[" + ownerTenantId + "]} by tenant {[" + callerTenantDomain + "],[" + callerTenantId + "]}");
        }
    }

    private static CarbonContext getCarbonContext() {
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        if (carbonContext == null) {
            throw new IllegalStateException("CarbonContext cannot be null");
        }
        return carbonContext;
    }

    public static String getDistributedMapNameOfCache(String cacheName, String ownerTenantDomain, String cacheManagerName) {
        return "$cache.$domain[" + ownerTenantDomain + "]" + cacheManagerName + "#" + cacheName;
    }

    public static String getTenantDomain() {
        return Util.getCarbonContext().getTenantDomain();
    }

    public static long getDefaultCacheTimeout() {
        ServerConfigurationService serverConfigService = DataHolder.getInstance().getServerConfigurationService();
        if (serverConfigService != null) {
            String defaultCacheTimeoutValue = serverConfigService.getFirstProperty("Cache.DefaultCacheTimeout");
            return defaultCacheTimeoutValue == null ? 15L : Long.parseLong(defaultCacheTimeoutValue);
        }
        return 15L;
    }

    private Util() {
    }
}

