/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CharacterSetFilter
implements Filter {
    private static final String UTF8 = "UTF-8";
    private static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    private String encoding;

    public String getEncoding() {
        return this.encoding;
    }

    public void init(FilterConfig config) throws ServletException {
        this.encoding = config.getInitParameter("requestEncoding");
        if (this.encoding == null) {
            this.encoding = UTF8;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (null == request.getCharacterEncoding()) {
            request.setCharacterEncoding(this.encoding);
        }
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(UTF8);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

