/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.realms;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.saas.TenantSaaSRules;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonTomcatRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(CarbonTomcatRealm.class);
    private Map<String, TenantSaaSRules> tenantSaaSRulesMap = null;
    private boolean isSaaSEnabled = false;

    public boolean getEnableSaaS() {
        return this.isSaaSEnabled;
    }

    public void setEnableSaaS(boolean enableSaaS) {
        this.isSaaSEnabled = enableSaaS;
    }

    public Map getSaasRules() {
        return this.tenantSaaSRulesMap;
    }

    public void setSaasRules(String saaSRules) {
        this.tenantSaaSRulesMap = this.getProcessedSaaSRules(saaSRules);
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("When CarbonTomcatRealm is in operation this method getPassword(String) should never be called");
    }

    public Principal authenticate(String username, String response, String nonce, String nc, String cNonce, String qop, String realmName, String md5) {
        throw new IllegalStateException("Carbon doesn't use MD5 hashes. Can't do digest authentication");
    }

    public Principal authenticate(String userName, String credential) {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        String tenantLessUserName = CarbonTomcatRealm.getTenantLessUserName(userName);
        if ("carbon.super".equals(tenantDomain)) {
            userName = userName + "@" + "carbon.super";
        }
        try {
            RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
            int tenantId = userRealmService.getTenantManager().getTenantId(tenantDomain);
            if (tenantId == -1) {
                return null;
            }
            String[] roles = userRealmService.getTenantUserRealm(tenantId).getUserStoreManager().getRoleListOfUser(tenantLessUserName);
            if (!this.checkSaasAccess(tenantDomain, tenantLessUserName, roles)) {
                String requestTenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                if (tenantDomain != null && !tenantDomain.equals(requestTenantDomain)) {
                    if (requestTenantDomain.trim().length() == 0) {
                        requestTenantDomain = "0";
                    }
                    log.warn((Object)("Illegal access attempt by " + userName + " to secured resource hosted by tenant " + requestTenantDomain));
                    return null;
                }
            }
            if (!userRealmService.getTenantUserRealm(tenantId).getUserStoreManager().authenticate(tenantLessUserName, (Object)credential)) {
                return null;
            }
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setUsername(tenantLessUserName);
            return this.getPrincipal(userName);
        }
        catch (UserStoreException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getTenantLessUserName(String userName) {
        String tenantLessUserName = userName.lastIndexOf(64) > -1 ? userName.substring(0, userName.lastIndexOf(64)) : userName;
        return tenantLessUserName;
    }

    private Map<String, TenantSaaSRules> getProcessedSaaSRules(String saaSRules) {
        String[] enableSaaSParams = saaSRules.replaceAll("\\s", "").split(";");
        HashMap<String, TenantSaaSRules> tenantSaaSRulesMap = new HashMap<String, TenantSaaSRules>();
        for (String saaSParam : enableSaaSParams) {
            String[] saaSSubParams = saaSParam.split(":");
            String tenant = saaSSubParams[0];
            TenantSaaSRules tenantSaaSRules = new TenantSaaSRules();
            ArrayList<String> users = null;
            ArrayList<String> roles = null;
            if (saaSSubParams.length > 1) {
                tenantSaaSRules.setTenant(tenant);
                for (int i = 1; i < saaSSubParams.length; ++i) {
                    String[] saaSTypes = saaSSubParams[i].split("=");
                    if ("users".equals(saaSTypes[0]) && saaSTypes.length == 2) {
                        users = new ArrayList<String>();
                        users.addAll(Arrays.asList(saaSTypes[1].split(",")));
                        continue;
                    }
                    if (!"roles".equals(saaSTypes[0]) || saaSTypes.length != 2) continue;
                    roles = new ArrayList<String>();
                    roles.addAll(Arrays.asList(saaSTypes[1].split(",")));
                }
            }
            if (users != null) {
                tenantSaaSRules.setUsers(users);
            }
            if (roles != null) {
                tenantSaaSRules.setRoles(roles);
            }
            tenantSaaSRulesMap.put(tenant, tenantSaaSRules);
        }
        return tenantSaaSRulesMap;
    }

    private boolean checkSaasAccess(String tenantDomain, String userName, String[] userRoles) {
        if (!this.isSaaSEnabled) {
            return false;
        }
        Set<String> saaSTenants = this.tenantSaaSRulesMap.keySet();
        List<String> userRolesList = Arrays.asList(userRoles);
        boolean isUserAccepted = false;
        boolean isRoleAccepted = false;
        boolean isTenantAccepted = false;
        if (userName == null || tenantDomain == null) {
            return false;
        }
        if (saaSTenants.contains("!".concat(tenantDomain))) {
            return false;
        }
        if (saaSTenants.contains(tenantDomain)) {
            TenantSaaSRules tenantSaaSRules = this.tenantSaaSRulesMap.get(tenantDomain);
            ArrayList<String> users = tenantSaaSRules.getUsers();
            ArrayList<String> roles = tenantSaaSRules.getRoles();
            if (users != null && users.contains("!".concat(userName))) {
                return false;
            }
            if (roles != null) {
                boolean contains = false;
                for (String userRole : userRolesList) {
                    if (roles.contains("!".concat(userRole))) {
                        return false;
                    }
                    if (!roles.contains(userRole)) continue;
                    contains = true;
                }
                if (contains || roles.contains("*")) {
                    isRoleAccepted = true;
                }
            } else if (users != null && (users.contains(userName) || users.contains("*"))) {
                isUserAccepted = true;
            }
        } else if (saaSTenants.contains(tenantDomain) && !this.tenantSaaSRulesMap.get(tenantDomain).isTenantRulesDefined() || saaSTenants.contains("*")) {
            isTenantAccepted = true;
        }
        return isUserAccepted || isTenantAccepted || isRoleAccepted;
    }

    protected Principal getPrincipal(String userNameWithTenant) {
        return new GenericCarbonPrincipal(userNameWithTenant);
    }

    private static class GenericCarbonPrincipal
    extends GenericPrincipal {
        private String tenantDomain = null;

        public GenericCarbonPrincipal(String name) {
            super(name, null, GenericCarbonPrincipal.getCarbonRoles(name));
            if (name.contains("@")) {
                this.tenantDomain = name.substring(name.indexOf(64) + 1);
            }
        }

        private static List<String> getCarbonRoles(String userName) {
            try {
                String tenantDomain = null;
                if (userName.contains("@")) {
                    tenantDomain = userName.substring(userName.indexOf(64) + 1);
                }
                RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
                int tenantId = userRealmService.getTenantManager().getTenantId(tenantDomain);
                String tenantLessUserName = CarbonTomcatRealm.getTenantLessUserName(userName);
                String[] roles = userRealmService.getTenantUserRealm(tenantId).getUserStoreManager().getRoleListOfUser(tenantLessUserName);
                return Arrays.asList(roles);
            }
            catch (UserStoreException e) {
                log.error((Object)("Error occurred while retrieving the roles of the user - " + userName), (Throwable)e);
                return null;
            }
        }

        public String getPassword() {
            throw new IllegalStateException("When CarbonTomcatRealm is in operation this method Principal.getPassword() should never be called");
        }

        public boolean hasRole(String role) {
            try {
                RealmService realmService = CarbonRealmServiceHolder.getRealmService();
                int tenantId = realmService.getTenantManager().getTenantId(this.tenantDomain);
                int indexOfAt = this.name.lastIndexOf(64);
                String tenantLessUserName = indexOfAt == -1 ? this.name : this.name.substring(0, indexOfAt);
                Object[] roles = CarbonRealmServiceHolder.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager().getRoleListOfUser(tenantLessUserName);
                Arrays.sort(roles);
                return Arrays.binarySearch(roles, role) > -1;
            }
            catch (UserStoreException e) {
                log.error((Object)"Cannot check role", (Throwable)e);
                return false;
            }
        }
    }
}

