/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.StuckThreadDetectionValve;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.wso2.carbon.tomcat.ext.internal.Utils;

public class CarbonStuckThreadDetectionValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.StuckThreadDetectionValve/1.0";
    private static final Log log = LogFactory.getLog(StuckThreadDetectionValve.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    private final AtomicInteger stuckCount = new AtomicInteger(0);
    private int threshold = 600;
    private ConcurrentHashMap<Long, MonitoredThread> activeThreads = new ConcurrentHashMap();

    public CarbonStuckThreadDetectionValve() {
        super(true);
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Monitoring stuck threads with threshold = " + this.threshold + " sec"));
        }
    }

    public String getInfo() {
        return info;
    }

    private void handleStuckThread(MonitoredThread monitoredThread, long activeTime, int numStuckThreads) {
        String msg = sm.getString("stuckThreadDetectionValve.notifyStuckThreadDetected", new Object[]{monitoredThread.getThread().getName(), activeTime, monitoredThread.getStartTime(), numStuckThreads, monitoredThread.getRequestUri(), this.threshold});
        msg = msg + ", tenantDomain=" + monitoredThread.getTenantDomain();
        Throwable th = new Throwable();
        th.setStackTrace(monitoredThread.getThread().getStackTrace());
        log.warn((Object)msg, th);
        monitoredThread.getThread().interrupt();
        monitoredThread.getThread().stop();
        this.activeThreads.remove(monitoredThread.getThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.threshold <= 0) {
            this.getNext().invoke(request, response);
            return;
        }
        Long key = Thread.currentThread().getId();
        StringBuffer requestUrl = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestUrl.append("?");
            requestUrl.append(request.getQueryString());
        }
        String tenantDomain = Utils.getTenantDomain((HttpServletRequest)request);
        MonitoredThread monitoredThread = new MonitoredThread(Thread.currentThread(), requestUrl.toString(), tenantDomain);
        this.activeThreads.put(key, monitoredThread);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.activeThreads.remove(key);
        }
    }

    public void backgroundProcess() {
        super.backgroundProcess();
        long thresholdInMillis = (long)this.threshold * 1000L;
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            long activeTime = monitoredThread.getActiveTimeInMillis();
            if (activeTime < thresholdInMillis || !monitoredThread.markAsStuckIfStillRunning()) continue;
            int numStuckThreads = this.stuckCount.incrementAndGet();
            this.handleStuckThread(monitoredThread, activeTime, numStuckThreads);
        }
    }

    private static enum MonitoredThreadState {
        RUNNING,
        STUCK;

    }

    private static class MonitoredThread {
        private final Thread thread;
        private final String requestUri;
        private final long start;
        private String tenantDomain;
        private final AtomicInteger state = new AtomicInteger(MonitoredThreadState.RUNNING.ordinal());

        public MonitoredThread(Thread thread, String requestUri, String tenantDomain) {
            this.thread = thread;
            this.requestUri = requestUri;
            this.tenantDomain = tenantDomain;
            this.start = System.currentTimeMillis();
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public long getActiveTimeInMillis() {
            return System.currentTimeMillis() - this.start;
        }

        public Date getStartTime() {
            return new Date(this.start);
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public boolean markAsStuckIfStillRunning() {
            return this.state.compareAndSet(MonitoredThreadState.RUNNING.ordinal(), MonitoredThreadState.STUCK.ordinal());
        }
    }
}

