/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.core.ghostregistry.GhostRegistry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.internal.Utils;
import org.wso2.carbon.tomcat.ext.realms.CarbonTomcatRealm;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.core.service.RealmService;

public class CompositeValve
extends ValveBase {
    private static Log log = LogFactory.getLog(CompositeValve.class);
    private static final String ENABLE_SAAS = "carbon.enable.saas";

    public CompositeValve() {
        super(true);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            String enableSaaSParam = request.getContext().findParameter(ENABLE_SAAS);
            Realm realm = request.getContext().getRealm();
            if (realm instanceof CarbonTomcatRealm && enableSaaSParam != null && ((CarbonTomcatRealm)realm).getSaasRules() == null) {
                String contextName = request.getContext().getName();
                log.warn((Object)("To enable SaaS mode for the webapp, " + contextName + ", configure the CarbonTomcatRealm in META-INF/context.xml."));
            }
            TomcatValveContainer.invokeValves(request, response, this);
        }
        catch (Exception e) {
            log.error((Object)("Could not handle request: " + request.getRequestURI()), (Throwable)e);
        }
    }

    public void continueInvocation(Request request, Response response) {
        try {
            int status;
            String requestedHostName = request.getHost().getName();
            String defaultHost = URLMappingHolder.getInstance().getDefaultHost();
            if (!requestedHostName.equalsIgnoreCase(defaultHost)) {
                PrivilegedCarbonContext carbonContext;
                String tenantDomain = Utils.getTenantDomainFromURLMapping(request);
                if (!tenantDomain.equalsIgnoreCase((carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext()).getTenantDomain())) {
                    carbonContext.setTenantDomain(tenantDomain);
                }
                carbonContext.setApplicationName(Utils.getAppNameForURLMapping(request));
                RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
                TenantManager tenantManager = userRealmService.getTenantManager();
                int tenantId = tenantManager.getTenantId(tenantDomain);
                carbonContext.setTenantId(tenantId);
                carbonContext.setUserRealm(userRealmService.getTenantUserRealm(tenantId));
                RegistryService registryService = CarbonRealmServiceHolder.getRegistryService();
                carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (Registry)new GhostRegistry((org.wso2.carbon.registry.api.RegistryService)registryService, tenantId, RegistryType.SYSTEM_CONFIGURATION));
                carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (Registry)new GhostRegistry((org.wso2.carbon.registry.api.RegistryService)registryService, tenantId, RegistryType.SYSTEM_GOVERNANCE));
            }
            if ((status = response.getStatus()) != 302 && status != 403) {
                this.getNext().invoke(request, response);
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not handle request: " + request.getRequestURI()), (Throwable)e);
        }
    }
}

