/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec.stream.slf4j;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.stream.CallerLoggerUtil;
import org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jErrorOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jInfoOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jTraceOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jWarnOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slf4jStream {
    private final Logger log;

    private Slf4jStream(Logger log) {
        this.log = log;
    }

    public static Slf4jStream of(Logger log) {
        return new Slf4jStream(log);
    }

    public static Slf4jStream of(Class<?> klass) {
        return Slf4jStream.of(LoggerFactory.getLogger(klass));
    }

    public static Slf4jStream of(String name) {
        return Slf4jStream.of(LoggerFactory.getLogger((String)CallerLoggerUtil.getName(name, 1)));
    }

    public static Slf4jStream ofCaller() {
        return Slf4jStream.of(LoggerFactory.getLogger((String)CallerLoggerUtil.getName(null, 1)));
    }

    public Slf4jOutputStream asTrace() {
        return new Slf4jTraceOutputStream(this.log);
    }

    public Slf4jOutputStream asDebug() {
        return new Slf4jDebugOutputStream(this.log);
    }

    public Slf4jOutputStream asInfo() {
        return new Slf4jInfoOutputStream(this.log);
    }

    public Slf4jOutputStream asWarn() {
        return new Slf4jWarnOutputStream(this.log);
    }

    public Slf4jOutputStream asError() {
        return new Slf4jErrorOutputStream(this.log);
    }
}

