/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZTFileUtil {
    private ZTFileUtil() {
    }

    public static Collection<File> listFiles(File dir) {
        return ZTFileUtil.listFiles(dir, null);
    }

    public static Collection<File> listFiles(File dir, FileFilter filter) {
        ArrayList<File> accumulator = new ArrayList<File>();
        if (dir.isFile()) {
            return accumulator;
        }
        if (filter == null) {
            filter = new FileFilter(){

                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        ZTFileUtil.innerListFiles(dir, accumulator, filter);
        return accumulator;
    }

    private static void innerListFiles(File dir, Collection<File> accumulator, FileFilter filter) {
        String[] filenames = dir.list();
        if (filenames != null) {
            for (int i = 0; i < filenames.length; ++i) {
                File file = new File(dir, filenames[i]);
                if (file.isDirectory()) {
                    ZTFileUtil.innerListFiles(file, accumulator, filter);
                    continue;
                }
                if (filter == null || !filter.accept(file)) continue;
                accumulator.add(file);
            }
        }
    }
}

