/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisDataException;

public class Pipeline
extends MultiKeyPipelineBase {
    private MultiResponseBuilder currentMulti;

    @Override
    protected <T> Response<T> getResponse(Builder<T> builder) {
        if (this.currentMulti != null) {
            super.getResponse(BuilderFactory.STRING);
            Response<T> lr = new Response<T>(builder);
            this.currentMulti.addResponse(lr);
            return lr;
        }
        return super.getResponse(builder);
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    protected Client getClient(byte[] key) {
        return this.client;
    }

    @Override
    protected Client getClient(String key) {
        return this.client;
    }

    public void sync() {
        List<Object> unformatted = this.client.getAll();
        for (Object o : unformatted) {
            this.generateResponse(o);
        }
    }

    public List<Object> syncAndReturnAll() {
        List<Object> unformatted = this.client.getAll();
        ArrayList<Object> formatted = new ArrayList<Object>();
        for (Object o : unformatted) {
            try {
                formatted.add(this.generateResponse(o).get());
            }
            catch (JedisDataException e) {
                formatted.add(e);
            }
        }
        return formatted;
    }

    public Response<String> discard() {
        if (this.currentMulti == null) {
            throw new JedisDataException("DISCARD without MULTI");
        }
        this.client.discard();
        this.currentMulti = null;
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<Object>> exec() {
        if (this.currentMulti == null) {
            throw new JedisDataException("EXEC without MULTI");
        }
        this.client.exec();
        Response<List<Object>> response = super.getResponse(this.currentMulti);
        this.currentMulti.setResponseDependency(response);
        this.currentMulti = null;
        return response;
    }

    public Response<String> multi() {
        if (this.currentMulti != null) {
            throw new JedisDataException("MULTI calls can not be nested");
        }
        this.client.multi();
        Response<String> response = this.getResponse(BuilderFactory.STRING);
        this.currentMulti = new MultiResponseBuilder();
        return response;
    }

    private class MultiResponseBuilder
    extends Builder<List<Object>> {
        private List<Response<?>> responses = new ArrayList();

        private MultiResponseBuilder() {
        }

        @Override
        public List<Object> build(Object data) {
            List list = (List)data;
            ArrayList<Object> values = new ArrayList<Object>();
            if (list.size() != this.responses.size()) {
                throw new JedisDataException("Expected data size " + this.responses.size() + " but was " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                Response<?> response = this.responses.get(i);
                response.set(list.get(i));
                values.add(response.get());
            }
            return values;
        }

        public void setResponseDependency(Response<?> dependency) {
            for (Response<?> response : this.responses) {
                response.setDependency(dependency);
            }
        }

        public void addResponse(Response<?> response) {
            this.responses.add(response);
        }
    }
}

