/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionMath;
import oracle.toplink.essentials.internal.parsing.ArithmeticFunctionNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class ModNode
extends ArithmeticFunctionNode {
    private Node denominator = null;

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(context);
        }
        if (this.denominator != null) {
            this.denominator = this.denominator.qualifyAttributeAccess(context);
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getIntType());
            Object type = this.left.getType();
            if (!typeHelper.isIntegralType(type)) {
                throw EJBQLException.invalidFunctionArgument(context.getQueryInfo(), this.left.getLine(), this.left.getColumn(), "MOD", this.left.getAsString(), "integral type");
            }
        }
        if (this.denominator != null) {
            this.denominator.validate(context);
            this.denominator.validateParameter(context, typeHelper.getIntType());
            Object denominatorType = this.denominator.getType();
            if (!typeHelper.isIntegralType(denominatorType)) {
                throw EJBQLException.invalidFunctionArgument(context.getQueryInfo(), this.denominator.getLine(), this.denominator.getColumn(), "MOD", this.denominator.getAsString(), "integral type");
            }
        }
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        return ExpressionMath.mod(this.getLeft().generateExpression(context), this.getDenominator().generateExpression(context));
    }

    public Node getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Node denominator) {
        this.denominator = denominator;
    }
}

