/*
 * Decompiled with CFR 0.152.
 */
package org.bndtools.maven;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.bndtools.maven.MavenVersion;

@Mojo(name="bnd-process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BndMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=true)
    private File manifestPath;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        File bndFile = new File(this.project.getBasedir(), "bnd.bnd");
        Builder builder = new Builder();
        builder.setTrace(log.isDebugEnabled());
        try {
            if (bndFile.isFile()) {
                builder.setProperties(bndFile, this.project.getBasedir());
            } else {
                builder.setBase(this.project.getBasedir());
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            File builderFile = builder.getPropertiesFile();
            if (builderFile != null && !bndFile.equals(builderFile)) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            LinkedList<File> classpath = new LinkedList<File>();
            Set artifacts = this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                File artifactFile = artifact.getFile();
                if (artifactFile == null) continue;
                classpath.add(artifactFile);
            }
            classpath.add(this.classesDir);
            builder.setClasspath(classpath.toArray(new File[classpath.size()]));
            if (builder.hasSources()) {
                builder.setSourcepath(new File[]{this.sourceDir});
            }
            String includes = builder.getProperty("-includeresource");
            StringBuilder newIncludes = new StringBuilder().append('\"').append(this.classesDir.getPath()).append('\"');
            includes = includes == null || includes.trim().length() == 0 ? newIncludes.toString() : newIncludes.append(',').append(includes).toString();
            builder.setProperty("-includeresource", includes);
            MavenVersion mvnVersion = new MavenVersion(this.project.getVersion());
            builder.setProperty("Bundle-Version", mvnVersion.toBndVersion());
            Jar bndJar = builder.build();
            Files.createDirectories(this.manifestPath.toPath().getParent(), new FileAttribute[0]);
            FileOutputStream manifestOut = new FileOutputStream(this.manifestPath);
            try {
                bndJar.writeManifest((OutputStream)manifestOut);
            }
            finally {
                manifestOut.close();
            }
            BndMavenPlugin.expandJar(bndJar, this.classesDir);
            this.reportErrorsAndWarnings(builder);
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error", e);
        }
        finally {
            builder.close();
        }
    }

    private void reportErrorsAndWarnings(Builder builder) throws MojoExecutionException {
        List errors;
        Log log = this.getLog();
        List warnings = builder.getWarnings();
        if (warnings != null) {
            for (String warning : warnings) {
                log.warn((CharSequence)warning);
            }
        }
        if ((errors = builder.getErrors()) != null && !errors.isEmpty()) {
            for (String error : errors) {
                log.error((CharSequence)error);
            }
            if (errors.size() == 1) {
                throw new MojoExecutionException((String)errors.get(0));
            }
            throw new MojoExecutionException("Errors in bnd processing, see log for details.");
        }
    }

    private static void expandJar(Jar jar, File dir) throws Exception {
        if (!(dir = dir.getAbsoluteFile()).exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a dir: " + dir.getAbsolutePath());
        }
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getFile((File)dir, (String)((String)entry.getKey()));
            File outDir = outFile.getParentFile();
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new IOException("Could not create directory " + outDir);
            }
            Resource resource = (Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile())) continue;
            IO.copy((InputStream)((Resource)entry.getValue()).openInputStream(), (File)outFile);
        }
    }
}

