/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bnd-process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BndMavenPlugin
extends AbstractMojo {
    private static final String PACKAGING_POM = "pom";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String TSTAMP = "${tstamp}";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=true)
    private File manifestPath;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (PACKAGING_POM.equals(this.project.getPackaging())) {
            log.info((CharSequence)"skip project with packaging=pom");
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties(beanProperties);
        mavenProperties.putAll((Map<?, ?>)this.project.getProperties());
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            builder.setTrace(log.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.loadProjectProperties(builder, this.project);
            builder.setProperty("project.output", this.targetDir.getCanonicalPath());
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (this.classesDir.isDirectory()) {
                Jar classesDirJar = new Jar(this.project.getName(), this.classesDir);
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<File> buildpath = new ArrayList<File>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("jar")) continue;
                buildpath.add(artifact.getFile().getCanonicalFile());
            }
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            builder.setClasspath(buildpath.toArray(new File[buildpath.size()]));
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("builder classpath: " + builder.getProperty("project.buildpath")));
            }
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.sourceDir.exists()) {
                sourcepath.add(this.sourceDir.getCanonicalFile());
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            builder.setSourcepath(sourcepath.toArray(new File[sourcepath.size()]));
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("builder sourcepath: " + builder.getProperty("project.sourcepath")));
            }
            Version version = MavenVersion.parseString((String)this.project.getVersion()).getOSGiVersion();
            version = this.replaceSNAPSHOT(version);
            builder.setProperty("Bundle-Version", version.toString());
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("builder properties: " + builder.getProperties()));
            }
            Jar bndJar = builder.build();
            Files.createDirectories(this.manifestPath.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(this.manifestPath);){
                bndJar.writeManifest(manifestOut);
            }
            this.expandJar(bndJar, this.classesDir);
            this.reportErrorsAndWarnings(builder);
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error", e);
        }
    }

    private void loadProjectProperties(Builder builder, MavenProject project) throws Exception {
        File baseDir;
        File bndFile;
        MavenProject parentProject = project.getParent();
        if (parentProject != null) {
            this.loadProjectProperties(builder, parentProject);
        }
        if ((bndFile = new File(baseDir = project.getBasedir(), "bnd.bnd")).isFile()) {
            builder.setProperties(baseDir, builder.loadProperties(bndFile));
        }
    }

    private void reportErrorsAndWarnings(Builder builder) throws MojoExecutionException {
        Log log = this.getLog();
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            log.warn((CharSequence)warning);
        }
        List errors = builder.getErrors();
        for (String error : errors) {
            log.error((CharSequence)error);
        }
        if (!builder.isOk()) {
            if (errors.size() == 1) {
                throw new MojoExecutionException((String)errors.get(0));
            }
            throw new MojoExecutionException("Errors in bnd processing, see log for details.");
        }
    }

    private void expandJar(Jar jar, File dir) throws Exception {
        if (!(dir = dir.getAbsoluteFile()).exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a dir: " + dir.getAbsolutePath());
        }
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getFile((File)dir, (String)((String)entry.getKey()));
            File outDir = outFile.getParentFile();
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new IOException("Could not create directory " + outDir);
            }
            Resource resource = (Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile())) continue;
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            Throwable throwable = null;
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private Version replaceSNAPSHOT(Version version) {
        int i;
        String qualifier = version.getQualifier();
        if (qualifier != null && (i = qualifier.indexOf(SNAPSHOT)) >= 0) {
            qualifier = qualifier.substring(0, i) + TSTAMP + qualifier.substring(i + SNAPSHOT.length());
            version = new Version(version.getMajor(), version.getMinor(), version.getMicro(), qualifier);
        }
        return version;
    }

    private class BeanProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        BeanProperties() {
        }

        @Override
        public String getProperty(String key) {
            int i = key.indexOf(46);
            String name = i > 0 ? key.substring(0, i) : key;
            Object value = this.get(name);
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private Object getField(Object target, String key) {
            int i = key.indexOf(46);
            String fieldName = i > 0 ? key.substring(0, i) : key;
            String getterSuffix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Object value = null;
            try {
                Method getter;
                Class<?> targetClass = target.getClass();
                while (!Modifier.isPublic(targetClass.getModifiers())) {
                    targetClass = targetClass.getSuperclass();
                }
                try {
                    getter = targetClass.getMethod("get" + getterSuffix, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    getter = targetClass.getMethod("is" + getterSuffix, new Class[0]);
                }
                value = getter.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                BndMavenPlugin.this.getLog().debug((CharSequence)("Could not find getter method for field: " + fieldName), (Throwable)e);
            }
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            return value;
        }
    }
}

