/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import androidx.core.view.animation.PathInterpolatorCompat;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.lang.ref.WeakReference;

class KeyframeParser {
    private static final float MAX_CP_VALUE = 100.0f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache;
    static JsonReader.Options NAMES;

    KeyframeParser() {
    }

    private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache() {
        if (pathInterpolatorCache == null) {
            pathInterpolatorCache = new SparseArrayCompat();
        }
        return pathInterpolatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static WeakReference<Interpolator> getInterpolator(int hash) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (WeakReference)KeyframeParser.pathInterpolatorCache().get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInterpolator(int hash, WeakReference<Interpolator> interpolator) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            pathInterpolatorCache.put(hash, interpolator);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static <T> Keyframe<T> parse(JsonReader reader, LottieComposition composition, float scale, ValueParser<T> valueParser, boolean animated) throws IOException {
        if (animated) {
            return KeyframeParser.parseKeyframe(composition, reader, scale, valueParser);
        }
        return KeyframeParser.parseStaticValue(reader, scale, valueParser);
    }

    private static <T> Keyframe<T> parseKeyframe(LottieComposition composition, JsonReader reader, float scale, ValueParser<T> valueParser) throws IOException {
        PointF cp1 = null;
        PointF cp2 = null;
        float startFrame = 0.0f;
        Object startValue = null;
        Object endValue = null;
        boolean hold = false;
        Interpolator interpolator = null;
        PointF pathCp1 = null;
        PointF pathCp2 = null;
        reader.beginObject();
        block12: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    startFrame = (float)reader.nextDouble();
                    continue block12;
                }
                case 1: {
                    startValue = valueParser.parse(reader, scale);
                    continue block12;
                }
                case 2: {
                    endValue = valueParser.parse(reader, scale);
                    continue block12;
                }
                case 3: {
                    cp1 = JsonUtils.jsonToPoint(reader, scale);
                    continue block12;
                }
                case 4: {
                    cp2 = JsonUtils.jsonToPoint(reader, scale);
                    continue block12;
                }
                case 5: {
                    hold = reader.nextInt() == 1;
                    continue block12;
                }
                case 6: {
                    pathCp1 = JsonUtils.jsonToPoint(reader, scale);
                    continue block12;
                }
                case 7: {
                    pathCp2 = JsonUtils.jsonToPoint(reader, scale);
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (hold) {
            endValue = startValue;
            interpolator = LINEAR_INTERPOLATOR;
        } else if (cp1 != null && cp2 != null) {
            cp1.x = MiscUtils.clamp(cp1.x, -scale, scale);
            cp1.y = MiscUtils.clamp(cp1.y, -100.0f, 100.0f);
            cp2.x = MiscUtils.clamp(cp2.x, -scale, scale);
            cp2.y = MiscUtils.clamp(cp2.y, -100.0f, 100.0f);
            int hash = Utils.hashFor(cp1.x, cp1.y, cp2.x, cp2.y);
            WeakReference<Interpolator> interpolatorRef = KeyframeParser.getInterpolator(hash);
            if (interpolatorRef != null) {
                interpolator = (Interpolator)interpolatorRef.get();
            }
            if (interpolatorRef == null || interpolator == null) {
                interpolator = PathInterpolatorCompat.create((float)(cp1.x / scale), (float)(cp1.y / scale), (float)(cp2.x / scale), (float)(cp2.y / scale));
                try {
                    KeyframeParser.putInterpolator(hash, new WeakReference<Interpolator>(interpolator));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        } else {
            interpolator = LINEAR_INTERPOLATOR;
        }
        Keyframe<Object> keyframe = new Keyframe<Object>(composition, startValue, endValue, interpolator, startFrame, null);
        keyframe.pathCp1 = pathCp1;
        keyframe.pathCp2 = pathCp2;
        return keyframe;
    }

    private static <T> Keyframe<T> parseStaticValue(JsonReader reader, float scale, ValueParser<T> valueParser) throws IOException {
        T value = valueParser.parse(reader, scale);
        return new Keyframe<T>(value);
    }

    static {
        NAMES = JsonReader.Options.of("t", "s", "e", "o", "i", "h", "to", "ti");
    }
}

