/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.CertificateDetail;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationJsonMarshaller;
import com.amazonaws.services.certificatemanager.model.transform.RenewalSummaryJsonMarshaller;
import java.util.List;

public class CertificateDetailJsonMarshaller {
    private static CertificateDetailJsonMarshaller instance;

    public void marshall(CertificateDetail certificateDetail, StructuredJsonGenerator jsonGenerator) {
        if (certificateDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<DomainValidation> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            jsonGenerator.writeStartObject();
            if (certificateDetail.getCertificateArn() != null) {
                jsonGenerator.writeFieldName("CertificateArn").writeValue(certificateDetail.getCertificateArn());
            }
            if (certificateDetail.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(certificateDetail.getDomainName());
            }
            if ((subjectAlternativeNamesList = certificateDetail.getSubjectAlternativeNames()) != null) {
                jsonGenerator.writeFieldName("SubjectAlternativeNames");
                jsonGenerator.writeStartArray();
                for (String string : subjectAlternativeNamesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((domainValidationOptionsList = certificateDetail.getDomainValidationOptions()) != null) {
                jsonGenerator.writeFieldName("DomainValidationOptions");
                jsonGenerator.writeStartArray();
                for (DomainValidation domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (certificateDetail.getSerial() != null) {
                jsonGenerator.writeFieldName("Serial").writeValue(certificateDetail.getSerial());
            }
            if (certificateDetail.getSubject() != null) {
                jsonGenerator.writeFieldName("Subject").writeValue(certificateDetail.getSubject());
            }
            if (certificateDetail.getIssuer() != null) {
                jsonGenerator.writeFieldName("Issuer").writeValue(certificateDetail.getIssuer());
            }
            if (certificateDetail.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(certificateDetail.getCreatedAt());
            }
            if (certificateDetail.getIssuedAt() != null) {
                jsonGenerator.writeFieldName("IssuedAt").writeValue(certificateDetail.getIssuedAt());
            }
            if (certificateDetail.getImportedAt() != null) {
                jsonGenerator.writeFieldName("ImportedAt").writeValue(certificateDetail.getImportedAt());
            }
            if (certificateDetail.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(certificateDetail.getStatus());
            }
            if (certificateDetail.getRevokedAt() != null) {
                jsonGenerator.writeFieldName("RevokedAt").writeValue(certificateDetail.getRevokedAt());
            }
            if (certificateDetail.getRevocationReason() != null) {
                jsonGenerator.writeFieldName("RevocationReason").writeValue(certificateDetail.getRevocationReason());
            }
            if (certificateDetail.getNotBefore() != null) {
                jsonGenerator.writeFieldName("NotBefore").writeValue(certificateDetail.getNotBefore());
            }
            if (certificateDetail.getNotAfter() != null) {
                jsonGenerator.writeFieldName("NotAfter").writeValue(certificateDetail.getNotAfter());
            }
            if (certificateDetail.getKeyAlgorithm() != null) {
                jsonGenerator.writeFieldName("KeyAlgorithm").writeValue(certificateDetail.getKeyAlgorithm());
            }
            if (certificateDetail.getSignatureAlgorithm() != null) {
                jsonGenerator.writeFieldName("SignatureAlgorithm").writeValue(certificateDetail.getSignatureAlgorithm());
            }
            if ((list = certificateDetail.getInUseBy()) != null) {
                jsonGenerator.writeFieldName("InUseBy");
                jsonGenerator.writeStartArray();
                for (String inUseByListValue : list) {
                    if (inUseByListValue == null) continue;
                    jsonGenerator.writeValue(inUseByListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (certificateDetail.getFailureReason() != null) {
                jsonGenerator.writeFieldName("FailureReason").writeValue(certificateDetail.getFailureReason());
            }
            if (certificateDetail.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(certificateDetail.getType());
            }
            if (certificateDetail.getRenewalSummary() != null) {
                jsonGenerator.writeFieldName("RenewalSummary");
                RenewalSummaryJsonMarshaller.getInstance().marshall(certificateDetail.getRenewalSummary(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CertificateDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CertificateDetailJsonMarshaller();
        }
        return instance;
    }
}

