/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateModelRequestMarshaller
implements Marshaller<Request<CreateModelRequest>, CreateModelRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateModelRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateModelRequest> marshall(CreateModelRequest createModelRequest) {
        if (createModelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createModelRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/models";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createModelRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createModelRequest.getRestApiId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createModelRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createModelRequest.getName());
            }
            if (createModelRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createModelRequest.getDescription());
            }
            if (createModelRequest.getSchema() != null) {
                jsonGenerator.writeFieldName("schema").writeValue(createModelRequest.getSchema());
            }
            if (createModelRequest.getContentType() != null) {
                jsonGenerator.writeFieldName("contentType").writeValue(createModelRequest.getContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

