/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.MethodResponse;
import java.util.Map;

public class MethodResponseJsonMarshaller {
    private static MethodResponseJsonMarshaller instance;

    public void marshall(MethodResponse methodResponse, StructuredJsonGenerator jsonGenerator) {
        if (methodResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> responseModelsMap;
            Map<String, Boolean> responseParametersMap;
            jsonGenerator.writeStartObject();
            if (methodResponse.getStatusCode() != null) {
                jsonGenerator.writeFieldName("statusCode").writeValue(methodResponse.getStatusCode());
            }
            if ((responseParametersMap = methodResponse.getResponseParameters()) != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(responseParametersMapValue.getValue().booleanValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseModelsMap = methodResponse.getResponseModels()) != null) {
                jsonGenerator.writeFieldName("responseModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseModelsMapValue : responseModelsMap.entrySet()) {
                    if (responseModelsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseModelsMapValue.getKey());
                    jsonGenerator.writeValue(responseModelsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MethodResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MethodResponseJsonMarshaller();
        }
        return instance;
    }
}

