/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PutMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PutMethodRequestMarshaller
implements Marshaller<Request<PutMethodRequest>, PutMethodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutMethodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutMethodRequest> marshall(PutMethodRequest putMethodRequest) {
        if (putMethodRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodRequest.getHttpMethod()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> requestModelsMap;
            Map<String, Boolean> requestParametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putMethodRequest.getAuthorizationType() != null) {
                jsonGenerator.writeFieldName("authorizationType").writeValue(putMethodRequest.getAuthorizationType());
            }
            if (putMethodRequest.getAuthorizerId() != null) {
                jsonGenerator.writeFieldName("authorizerId").writeValue(putMethodRequest.getAuthorizerId());
            }
            if (putMethodRequest.getApiKeyRequired() != null) {
                jsonGenerator.writeFieldName("apiKeyRequired").writeValue(putMethodRequest.getApiKeyRequired().booleanValue());
            }
            if ((requestParametersMap = putMethodRequest.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)requestParametersMapValue.getKey());
                    jsonGenerator.writeValue(((Boolean)requestParametersMapValue.getValue()).booleanValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestModelsMap = putMethodRequest.getRequestModels()) != null) {
                jsonGenerator.writeFieldName("requestModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : requestModelsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

