/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutLifecycleHookRequestMarshaller
implements Marshaller<Request<PutLifecycleHookRequest>, PutLifecycleHookRequest> {
    @Override
    public Request<PutLifecycleHookRequest> marshall(PutLifecycleHookRequest putLifecycleHookRequest) {
        if (putLifecycleHookRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutLifecycleHookRequest> request = new DefaultRequest<PutLifecycleHookRequest>(putLifecycleHookRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutLifecycleHook");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putLifecycleHookRequest.getLifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringUtils.fromString(putLifecycleHookRequest.getLifecycleHookName()));
        }
        if (putLifecycleHookRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putLifecycleHookRequest.getAutoScalingGroupName()));
        }
        if (putLifecycleHookRequest.getLifecycleTransition() != null) {
            request.addParameter("LifecycleTransition", StringUtils.fromString(putLifecycleHookRequest.getLifecycleTransition()));
        }
        if (putLifecycleHookRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(putLifecycleHookRequest.getRoleARN()));
        }
        if (putLifecycleHookRequest.getNotificationTargetARN() != null) {
            request.addParameter("NotificationTargetARN", StringUtils.fromString(putLifecycleHookRequest.getNotificationTargetARN()));
        }
        if (putLifecycleHookRequest.getNotificationMetadata() != null) {
            request.addParameter("NotificationMetadata", StringUtils.fromString(putLifecycleHookRequest.getNotificationMetadata()));
        }
        if (putLifecycleHookRequest.getHeartbeatTimeout() != null) {
            request.addParameter("HeartbeatTimeout", StringUtils.fromInteger(putLifecycleHookRequest.getHeartbeatTimeout()));
        }
        if (putLifecycleHookRequest.getDefaultResult() != null) {
            request.addParameter("DefaultResult", StringUtils.fromString(putLifecycleHookRequest.getDefaultResult()));
        }
        return request;
    }
}

