/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateHsmRequestMarshaller
implements Marshaller<Request<CreateHsmRequest>, CreateHsmRequest> {
    public Request<CreateHsmRequest> marshall(CreateHsmRequest createHsmRequest) {
        if (createHsmRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHsmRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.CreateHsm");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createHsmRequest.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)createHsmRequest.getSubnetId());
            }
            if (createHsmRequest.getSshKey() != null) {
                jsonWriter.key("SshKey").value((Object)createHsmRequest.getSshKey());
            }
            if (createHsmRequest.getEniIp() != null) {
                jsonWriter.key("EniIp").value((Object)createHsmRequest.getEniIp());
            }
            if (createHsmRequest.getIamRoleArn() != null) {
                jsonWriter.key("IamRoleArn").value((Object)createHsmRequest.getIamRoleArn());
            }
            if (createHsmRequest.getExternalId() != null) {
                jsonWriter.key("ExternalId").value((Object)createHsmRequest.getExternalId());
            }
            if (createHsmRequest.getSubscriptionType() != null) {
                jsonWriter.key("SubscriptionType").value((Object)createHsmRequest.getSubscriptionType());
            }
            if (createHsmRequest.getClientToken() != null) {
                jsonWriter.key("ClientToken").value((Object)createHsmRequest.getClientToken());
            }
            if (createHsmRequest.getSyslogIp() != null) {
                jsonWriter.key("SyslogIp").value((Object)createHsmRequest.getSyslogIp());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

