/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.EnvironmentLanguage;
import com.amazonaws.services.codebuild.model.EnvironmentPlatform;
import com.amazonaws.services.codebuild.model.transform.EnvironmentLanguageJsonMarshaller;
import java.util.List;

public class EnvironmentPlatformJsonMarshaller {
    private static EnvironmentPlatformJsonMarshaller instance;

    public void marshall(EnvironmentPlatform environmentPlatform, StructuredJsonGenerator jsonGenerator) {
        if (environmentPlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<EnvironmentLanguage> languagesList;
            jsonGenerator.writeStartObject();
            if (environmentPlatform.getPlatform() != null) {
                jsonGenerator.writeFieldName("platform").writeValue(environmentPlatform.getPlatform());
            }
            if ((languagesList = environmentPlatform.getLanguages()) != null) {
                jsonGenerator.writeFieldName("languages");
                jsonGenerator.writeStartArray();
                for (EnvironmentLanguage languagesListValue : languagesList) {
                    if (languagesListValue == null) continue;
                    EnvironmentLanguageJsonMarshaller.getInstance().marshall(languagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnvironmentPlatformJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnvironmentPlatformJsonMarshaller();
        }
        return instance;
    }
}

