/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListApplicationRevisionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<RevisionLocation> revisions;
    private String nextToken;

    public List<RevisionLocation> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new SdkInternalList();
        }
        return this.revisions;
    }

    public void setRevisions(Collection<RevisionLocation> revisions) {
        if (revisions == null) {
            this.revisions = null;
            return;
        }
        this.revisions = new SdkInternalList(revisions);
    }

    public ListApplicationRevisionsResult withRevisions(RevisionLocation ... revisions) {
        if (this.revisions == null) {
            this.setRevisions((Collection<RevisionLocation>)new SdkInternalList(revisions.length));
        }
        for (RevisionLocation ele : revisions) {
            this.revisions.add((Object)ele);
        }
        return this;
    }

    public ListApplicationRevisionsResult withRevisions(Collection<RevisionLocation> revisions) {
        this.setRevisions(revisions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationRevisionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRevisions() != null) {
            sb.append("Revisions: " + this.getRevisions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResult)) {
            return false;
        }
        ListApplicationRevisionsResult other = (ListApplicationRevisionsResult)obj;
        if (other.getRevisions() == null ^ this.getRevisions() == null) {
            return false;
        }
        if (other.getRevisions() != null && !other.getRevisions().equals(this.getRevisions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRevisions() == null ? 0 : this.getRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListApplicationRevisionsResult clone() {
        try {
            return (ListApplicationRevisionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

