/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.GetApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetApplicationRevisionRequestMarshaller
implements Marshaller<Request<GetApplicationRevisionRequest>, GetApplicationRevisionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetApplicationRevisionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetApplicationRevisionRequest> marshall(GetApplicationRevisionRequest getApplicationRevisionRequest) {
        if (getApplicationRevisionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getApplicationRevisionRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.GetApplicationRevision");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getApplicationRevisionRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(getApplicationRevisionRequest.getApplicationName());
            }
            if (getApplicationRevisionRequest.getRevision() != null) {
                jsonGenerator.writeFieldName("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(getApplicationRevisionRequest.getRevision(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

