/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codepipeline.AWSCodePipelineAsync;
import com.amazonaws.services.codepipeline.AWSCodePipelineClient;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSCodePipelineAsyncClient
extends AWSCodePipelineClient
implements AWSCodePipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodePipelineAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCodePipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest acknowledgeJobRequest) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() {
                return AWSCodePipelineAsyncClient.this.acknowledgeJob(acknowledgeJobRequest);
            }
        });
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest acknowledgeJobRequest, final AsyncHandler<AcknowledgeJobRequest, AcknowledgeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() throws Exception {
                AcknowledgeJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeJob(acknowledgeJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)acknowledgeJobRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() {
                return AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(acknowledgeThirdPartyJobRequest);
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest, final AsyncHandler<AcknowledgeThirdPartyJobRequest, AcknowledgeThirdPartyJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() throws Exception {
                AcknowledgeThirdPartyJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(acknowledgeThirdPartyJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)acknowledgeThirdPartyJobRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() {
                return AWSCodePipelineAsyncClient.this.createCustomActionType(createCustomActionTypeRequest);
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest createCustomActionTypeRequest, final AsyncHandler<CreateCustomActionTypeRequest, CreateCustomActionTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() throws Exception {
                CreateCustomActionTypeResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createCustomActionType(createCustomActionTypeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createCustomActionTypeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() {
                return AWSCodePipelineAsyncClient.this.createPipeline(createPipelineRequest);
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createPipeline(createPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createPipelineRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.deleteCustomActionType(deleteCustomActionTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest deleteCustomActionTypeRequest, final AsyncHandler<DeleteCustomActionTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deleteCustomActionType(deleteCustomActionTypeRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteCustomActionTypeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest, final AsyncHandler<DeletePipelineRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deletePipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableStageTransitionAsync(final DisableStageTransitionRequest disableStageTransitionRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.disableStageTransition(disableStageTransitionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableStageTransitionAsync(final DisableStageTransitionRequest disableStageTransitionRequest, final AsyncHandler<DisableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.disableStageTransition(disableStageTransitionRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disableStageTransitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableStageTransitionAsync(final EnableStageTransitionRequest enableStageTransitionRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.enableStageTransition(enableStageTransitionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableStageTransitionAsync(final EnableStageTransitionRequest enableStageTransitionRequest, final AsyncHandler<EnableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.enableStageTransition(enableStageTransitionRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)enableStageTransitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest getJobDetailsRequest) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() {
                return AWSCodePipelineAsyncClient.this.getJobDetails(getJobDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest getJobDetailsRequest, final AsyncHandler<GetJobDetailsRequest, GetJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() throws Exception {
                GetJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getJobDetails(getJobDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getJobDetailsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest getPipelineRequest) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() {
                return AWSCodePipelineAsyncClient.this.getPipeline(getPipelineRequest);
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest getPipelineRequest, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipeline(getPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getPipelineRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest getPipelineStateRequest) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() {
                return AWSCodePipelineAsyncClient.this.getPipelineState(getPipelineStateRequest);
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest getPipelineStateRequest, final AsyncHandler<GetPipelineStateRequest, GetPipelineStateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() throws Exception {
                GetPipelineStateResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipelineState(getPipelineStateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getPipelineStateRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() {
                return AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(getThirdPartyJobDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest, final AsyncHandler<GetThirdPartyJobDetailsRequest, GetThirdPartyJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() throws Exception {
                GetThirdPartyJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(getThirdPartyJobDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getThirdPartyJobDetailsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest listActionTypesRequest) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() {
                return AWSCodePipelineAsyncClient.this.listActionTypes(listActionTypesRequest);
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest listActionTypesRequest, final AsyncHandler<ListActionTypesRequest, ListActionTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() throws Exception {
                ListActionTypesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listActionTypes(listActionTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listActionTypesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() {
                return AWSCodePipelineAsyncClient.this.listPipelines(listPipelinesRequest);
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listPipelines(listPipelinesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listPipelinesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest pollForJobsRequest) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() {
                return AWSCodePipelineAsyncClient.this.pollForJobs(pollForJobsRequest);
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest pollForJobsRequest, final AsyncHandler<PollForJobsRequest, PollForJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() throws Exception {
                PollForJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForJobs(pollForJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)pollForJobsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() {
                return AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(pollForThirdPartyJobsRequest);
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest, final AsyncHandler<PollForThirdPartyJobsRequest, PollForThirdPartyJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() throws Exception {
                PollForThirdPartyJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(pollForThirdPartyJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)pollForThirdPartyJobsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest putActionRevisionRequest) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() {
                return AWSCodePipelineAsyncClient.this.putActionRevision(putActionRevisionRequest);
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest putActionRevisionRequest, final AsyncHandler<PutActionRevisionRequest, PutActionRevisionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() throws Exception {
                PutActionRevisionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putActionRevision(putActionRevisionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putActionRevisionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobFailureResultAsync(final PutJobFailureResultRequest putJobFailureResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putJobFailureResult(putJobFailureResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putJobFailureResultAsync(final PutJobFailureResultRequest putJobFailureResultRequest, final AsyncHandler<PutJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobFailureResult(putJobFailureResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putJobFailureResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(final PutJobSuccessResultRequest putJobSuccessResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putJobSuccessResult(putJobSuccessResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(final PutJobSuccessResultRequest putJobSuccessResultRequest, final AsyncHandler<PutJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobSuccessResult(putJobSuccessResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putJobSuccessResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(putThirdPartyJobFailureResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest, final AsyncHandler<PutThirdPartyJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(putThirdPartyJobFailureResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putThirdPartyJobFailureResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(putThirdPartyJobSuccessResultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest, final AsyncHandler<PutThirdPartyJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(putThirdPartyJobSuccessResultRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putThirdPartyJobSuccessResultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest startPipelineExecutionRequest) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() {
                return AWSCodePipelineAsyncClient.this.startPipelineExecution(startPipelineExecutionRequest);
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest startPipelineExecutionRequest, final AsyncHandler<StartPipelineExecutionRequest, StartPipelineExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() throws Exception {
                StartPipelineExecutionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.startPipelineExecution(startPipelineExecutionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startPipelineExecutionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() {
                return AWSCodePipelineAsyncClient.this.updatePipeline(updatePipelineRequest);
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.updatePipeline(updatePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updatePipelineRequest, (Object)result);
                return result;
            }
        });
    }
}

