/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.comprehend.AmazonComprehend;
import com.amazonaws.services.comprehend.AmazonComprehendClientBuilder;
import com.amazonaws.services.comprehend.model.AmazonComprehendException;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchDetectSyntaxRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSyntaxResult;
import com.amazonaws.services.comprehend.model.BatchSizeLimitExceededException;
import com.amazonaws.services.comprehend.model.ConcurrentModificationException;
import com.amazonaws.services.comprehend.model.CreateDocumentClassifierRequest;
import com.amazonaws.services.comprehend.model.CreateDocumentClassifierResult;
import com.amazonaws.services.comprehend.model.CreateEntityRecognizerRequest;
import com.amazonaws.services.comprehend.model.CreateEntityRecognizerResult;
import com.amazonaws.services.comprehend.model.DeleteDocumentClassifierRequest;
import com.amazonaws.services.comprehend.model.DeleteDocumentClassifierResult;
import com.amazonaws.services.comprehend.model.DeleteEntityRecognizerRequest;
import com.amazonaws.services.comprehend.model.DeleteEntityRecognizerResult;
import com.amazonaws.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import com.amazonaws.services.comprehend.model.DescribeDocumentClassificationJobResult;
import com.amazonaws.services.comprehend.model.DescribeDocumentClassifierRequest;
import com.amazonaws.services.comprehend.model.DescribeDocumentClassifierResult;
import com.amazonaws.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeEntityRecognizerRequest;
import com.amazonaws.services.comprehend.model.DescribeEntityRecognizerResult;
import com.amazonaws.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeSentimentDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobResult;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.DetectEntitiesResult;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.DetectSentimentRequest;
import com.amazonaws.services.comprehend.model.DetectSentimentResult;
import com.amazonaws.services.comprehend.model.DetectSyntaxRequest;
import com.amazonaws.services.comprehend.model.DetectSyntaxResult;
import com.amazonaws.services.comprehend.model.InternalServerException;
import com.amazonaws.services.comprehend.model.InvalidFilterException;
import com.amazonaws.services.comprehend.model.InvalidRequestException;
import com.amazonaws.services.comprehend.model.JobNotFoundException;
import com.amazonaws.services.comprehend.model.KmsKeyValidationException;
import com.amazonaws.services.comprehend.model.ListDocumentClassificationJobsRequest;
import com.amazonaws.services.comprehend.model.ListDocumentClassificationJobsResult;
import com.amazonaws.services.comprehend.model.ListDocumentClassifiersRequest;
import com.amazonaws.services.comprehend.model.ListDocumentClassifiersResult;
import com.amazonaws.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListDominantLanguageDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListEntitiesDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListEntityRecognizersRequest;
import com.amazonaws.services.comprehend.model.ListEntityRecognizersResult;
import com.amazonaws.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListKeyPhrasesDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListSentimentDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListSentimentDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListTagsForResourceRequest;
import com.amazonaws.services.comprehend.model.ListTagsForResourceResult;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ResourceInUseException;
import com.amazonaws.services.comprehend.model.ResourceLimitExceededException;
import com.amazonaws.services.comprehend.model.ResourceNotFoundException;
import com.amazonaws.services.comprehend.model.ResourceUnavailableException;
import com.amazonaws.services.comprehend.model.StartDocumentClassificationJobRequest;
import com.amazonaws.services.comprehend.model.StartDocumentClassificationJobResult;
import com.amazonaws.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartSentimentDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopSentimentDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import com.amazonaws.services.comprehend.model.StopTrainingDocumentClassifierResult;
import com.amazonaws.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import com.amazonaws.services.comprehend.model.StopTrainingEntityRecognizerResult;
import com.amazonaws.services.comprehend.model.TagResourceRequest;
import com.amazonaws.services.comprehend.model.TagResourceResult;
import com.amazonaws.services.comprehend.model.TextSizeLimitExceededException;
import com.amazonaws.services.comprehend.model.TooManyRequestsException;
import com.amazonaws.services.comprehend.model.TooManyTagKeysException;
import com.amazonaws.services.comprehend.model.TooManyTagsException;
import com.amazonaws.services.comprehend.model.UnsupportedLanguageException;
import com.amazonaws.services.comprehend.model.UntagResourceRequest;
import com.amazonaws.services.comprehend.model.UntagResourceResult;
import com.amazonaws.services.comprehend.model.transform.BatchDetectDominantLanguageRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectDominantLanguageResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectKeyPhrasesRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectKeyPhrasesResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectSentimentRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectSentimentResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectSyntaxRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.BatchDetectSyntaxResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.CreateDocumentClassifierRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.CreateDocumentClassifierResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.CreateEntityRecognizerRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.CreateEntityRecognizerResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DeleteDocumentClassifierRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DeleteDocumentClassifierResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DeleteEntityRecognizerRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DeleteEntityRecognizerResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDocumentClassificationJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDocumentClassificationJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDocumentClassifierRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDocumentClassifierResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDominantLanguageDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeDominantLanguageDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeEntitiesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeEntitiesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeEntityRecognizerRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeEntityRecognizerResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeKeyPhrasesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeKeyPhrasesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeSentimentDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeSentimentDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeTopicsDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DescribeTopicsDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectDominantLanguageRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectDominantLanguageResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectKeyPhrasesRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectKeyPhrasesResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectSentimentRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectSentimentResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectSyntaxRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.DetectSyntaxResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDocumentClassificationJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDocumentClassificationJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDocumentClassifiersRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDocumentClassifiersResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDominantLanguageDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListDominantLanguageDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListEntitiesDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListEntitiesDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListEntityRecognizersRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListEntityRecognizersResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListKeyPhrasesDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListKeyPhrasesDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListSentimentDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListSentimentDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.ListTopicsDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.ListTopicsDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartDocumentClassificationJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartDocumentClassificationJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartDominantLanguageDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartDominantLanguageDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartEntitiesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartEntitiesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartKeyPhrasesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartKeyPhrasesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartSentimentDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartSentimentDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StartTopicsDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StartTopicsDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopDominantLanguageDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopDominantLanguageDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopEntitiesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopEntitiesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopKeyPhrasesDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopKeyPhrasesDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopSentimentDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopSentimentDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopTrainingDocumentClassifierRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopTrainingDocumentClassifierResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.StopTrainingEntityRecognizerRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.StopTrainingEntityRecognizerResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.comprehend.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.comprehend.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonComprehendClient
extends AmazonWebServiceClient
implements AmazonComprehend {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonComprehend.class);
    private static final String DEFAULT_SIGNING_NAME = "comprehend";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsKeyValidationException").withModeledClass(KmsKeyValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidFilterException").withModeledClass(InvalidFilterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagKeysException").withModeledClass(TooManyTagKeysException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BatchSizeLimitExceededException").withModeledClass(BatchSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextSizeLimitExceededException").withModeledClass(TextSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLanguageException").withModeledClass(UnsupportedLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withModeledClass(TooManyTagsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceUnavailableException").withModeledClass(ResourceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("JobNotFoundException").withModeledClass(JobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withModeledClass(ResourceLimitExceededException.class)).withBaseServiceExceptionClass(AmazonComprehendException.class));

    public static AmazonComprehendClientBuilder builder() {
        return AmazonComprehendClientBuilder.standard();
    }

    AmazonComprehendClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonComprehendClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("comprehend.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/comprehend/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/comprehend/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchDetectDominantLanguageResult batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request) {
        request = (BatchDetectDominantLanguageRequest)this.beforeClientExecution(request);
        return this.executeBatchDetectDominantLanguage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDetectDominantLanguageResult executeBatchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDetectDominantLanguageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDetectDominantLanguageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDetectDominantLanguageRequestProtocolMarshaller(protocolFactory).marshall((BatchDetectDominantLanguageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDetectDominantLanguageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDetectDominantLanguage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectDominantLanguageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDetectDominantLanguageResult batchDetectDominantLanguageResult = (BatchDetectDominantLanguageResult)response.getAwsResponse();
            return batchDetectDominantLanguageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDetectEntitiesResult batchDetectEntities(BatchDetectEntitiesRequest request) {
        request = (BatchDetectEntitiesRequest)this.beforeClientExecution(request);
        return this.executeBatchDetectEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDetectEntitiesResult executeBatchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDetectEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDetectEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDetectEntitiesRequestProtocolMarshaller(protocolFactory).marshall((BatchDetectEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDetectEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDetectEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDetectEntitiesResult batchDetectEntitiesResult = (BatchDetectEntitiesResult)response.getAwsResponse();
            return batchDetectEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDetectKeyPhrasesResult batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest request) {
        request = (BatchDetectKeyPhrasesRequest)this.beforeClientExecution(request);
        return this.executeBatchDetectKeyPhrases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDetectKeyPhrasesResult executeBatchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDetectKeyPhrasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDetectKeyPhrasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDetectKeyPhrasesRequestProtocolMarshaller(protocolFactory).marshall((BatchDetectKeyPhrasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDetectKeyPhrasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDetectKeyPhrases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectKeyPhrasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDetectKeyPhrasesResult batchDetectKeyPhrasesResult = (BatchDetectKeyPhrasesResult)response.getAwsResponse();
            return batchDetectKeyPhrasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDetectSentimentResult batchDetectSentiment(BatchDetectSentimentRequest request) {
        request = (BatchDetectSentimentRequest)this.beforeClientExecution(request);
        return this.executeBatchDetectSentiment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDetectSentimentResult executeBatchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDetectSentimentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDetectSentimentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDetectSentimentRequestProtocolMarshaller(protocolFactory).marshall((BatchDetectSentimentRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDetectSentimentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDetectSentiment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectSentimentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDetectSentimentResult batchDetectSentimentResult = (BatchDetectSentimentResult)response.getAwsResponse();
            return batchDetectSentimentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDetectSyntaxResult batchDetectSyntax(BatchDetectSyntaxRequest request) {
        request = (BatchDetectSyntaxRequest)this.beforeClientExecution(request);
        return this.executeBatchDetectSyntax(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDetectSyntaxResult executeBatchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDetectSyntaxRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDetectSyntaxRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDetectSyntaxRequestProtocolMarshaller(protocolFactory).marshall((BatchDetectSyntaxRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDetectSyntaxRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDetectSyntax");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectSyntaxResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDetectSyntaxResult batchDetectSyntaxResult = (BatchDetectSyntaxResult)response.getAwsResponse();
            return batchDetectSyntaxResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDocumentClassifierResult createDocumentClassifier(CreateDocumentClassifierRequest request) {
        request = (CreateDocumentClassifierRequest)this.beforeClientExecution(request);
        return this.executeCreateDocumentClassifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDocumentClassifierResult executeCreateDocumentClassifier(CreateDocumentClassifierRequest createDocumentClassifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDocumentClassifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDocumentClassifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDocumentClassifierRequestProtocolMarshaller(protocolFactory).marshall((CreateDocumentClassifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDocumentClassifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDocumentClassifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDocumentClassifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDocumentClassifierResult createDocumentClassifierResult = (CreateDocumentClassifierResult)response.getAwsResponse();
            return createDocumentClassifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEntityRecognizerResult createEntityRecognizer(CreateEntityRecognizerRequest request) {
        request = (CreateEntityRecognizerRequest)this.beforeClientExecution(request);
        return this.executeCreateEntityRecognizer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEntityRecognizerResult executeCreateEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEntityRecognizerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEntityRecognizerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEntityRecognizerRequestProtocolMarshaller(protocolFactory).marshall((CreateEntityRecognizerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEntityRecognizerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEntityRecognizer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEntityRecognizerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEntityRecognizerResult createEntityRecognizerResult = (CreateEntityRecognizerResult)response.getAwsResponse();
            return createEntityRecognizerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDocumentClassifierResult deleteDocumentClassifier(DeleteDocumentClassifierRequest request) {
        request = (DeleteDocumentClassifierRequest)this.beforeClientExecution(request);
        return this.executeDeleteDocumentClassifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDocumentClassifierResult executeDeleteDocumentClassifier(DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDocumentClassifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDocumentClassifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDocumentClassifierRequestProtocolMarshaller(protocolFactory).marshall((DeleteDocumentClassifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDocumentClassifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDocumentClassifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDocumentClassifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDocumentClassifierResult deleteDocumentClassifierResult = (DeleteDocumentClassifierResult)response.getAwsResponse();
            return deleteDocumentClassifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEntityRecognizerResult deleteEntityRecognizer(DeleteEntityRecognizerRequest request) {
        request = (DeleteEntityRecognizerRequest)this.beforeClientExecution(request);
        return this.executeDeleteEntityRecognizer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEntityRecognizerResult executeDeleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEntityRecognizerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEntityRecognizerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEntityRecognizerRequestProtocolMarshaller(protocolFactory).marshall((DeleteEntityRecognizerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEntityRecognizerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEntityRecognizer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEntityRecognizerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEntityRecognizerResult deleteEntityRecognizerResult = (DeleteEntityRecognizerResult)response.getAwsResponse();
            return deleteEntityRecognizerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDocumentClassificationJobResult describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest request) {
        request = (DescribeDocumentClassificationJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeDocumentClassificationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDocumentClassificationJobResult executeDescribeDocumentClassificationJob(DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentClassificationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentClassificationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentClassificationJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeDocumentClassificationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDocumentClassificationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDocumentClassificationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDocumentClassificationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDocumentClassificationJobResult describeDocumentClassificationJobResult = (DescribeDocumentClassificationJobResult)response.getAwsResponse();
            return describeDocumentClassificationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDocumentClassifierResult describeDocumentClassifier(DescribeDocumentClassifierRequest request) {
        request = (DescribeDocumentClassifierRequest)this.beforeClientExecution(request);
        return this.executeDescribeDocumentClassifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDocumentClassifierResult executeDescribeDocumentClassifier(DescribeDocumentClassifierRequest describeDocumentClassifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentClassifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentClassifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentClassifierRequestProtocolMarshaller(protocolFactory).marshall((DescribeDocumentClassifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDocumentClassifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDocumentClassifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDocumentClassifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDocumentClassifierResult describeDocumentClassifierResult = (DescribeDocumentClassifierResult)response.getAwsResponse();
            return describeDocumentClassifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDominantLanguageDetectionJobResult describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest request) {
        request = (DescribeDominantLanguageDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeDominantLanguageDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDominantLanguageDetectionJobResult executeDescribeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDominantLanguageDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDominantLanguageDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDominantLanguageDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeDominantLanguageDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDominantLanguageDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDominantLanguageDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDominantLanguageDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDominantLanguageDetectionJobResult describeDominantLanguageDetectionJobResult = (DescribeDominantLanguageDetectionJobResult)response.getAwsResponse();
            return describeDominantLanguageDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEntitiesDetectionJobResult describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest request) {
        request = (DescribeEntitiesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeEntitiesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEntitiesDetectionJobResult executeDescribeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEntitiesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEntitiesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEntitiesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeEntitiesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEntitiesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEntitiesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntitiesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEntitiesDetectionJobResult describeEntitiesDetectionJobResult = (DescribeEntitiesDetectionJobResult)response.getAwsResponse();
            return describeEntitiesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEntityRecognizerResult describeEntityRecognizer(DescribeEntityRecognizerRequest request) {
        request = (DescribeEntityRecognizerRequest)this.beforeClientExecution(request);
        return this.executeDescribeEntityRecognizer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEntityRecognizerResult executeDescribeEntityRecognizer(DescribeEntityRecognizerRequest describeEntityRecognizerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEntityRecognizerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEntityRecognizerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEntityRecognizerRequestProtocolMarshaller(protocolFactory).marshall((DescribeEntityRecognizerRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEntityRecognizerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEntityRecognizer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntityRecognizerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEntityRecognizerResult describeEntityRecognizerResult = (DescribeEntityRecognizerResult)response.getAwsResponse();
            return describeEntityRecognizerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeKeyPhrasesDetectionJobResult describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest request) {
        request = (DescribeKeyPhrasesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeKeyPhrasesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeKeyPhrasesDetectionJobResult executeDescribeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeKeyPhrasesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeKeyPhrasesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeKeyPhrasesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeKeyPhrasesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeKeyPhrasesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeKeyPhrasesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeKeyPhrasesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeKeyPhrasesDetectionJobResult describeKeyPhrasesDetectionJobResult = (DescribeKeyPhrasesDetectionJobResult)response.getAwsResponse();
            return describeKeyPhrasesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSentimentDetectionJobResult describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest request) {
        request = (DescribeSentimentDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeSentimentDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSentimentDetectionJobResult executeDescribeSentimentDetectionJob(DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSentimentDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSentimentDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSentimentDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeSentimentDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSentimentDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSentimentDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSentimentDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSentimentDetectionJobResult describeSentimentDetectionJobResult = (DescribeSentimentDetectionJobResult)response.getAwsResponse();
            return describeSentimentDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTopicsDetectionJobResult describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest request) {
        request = (DescribeTopicsDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeTopicsDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTopicsDetectionJobResult executeDescribeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTopicsDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTopicsDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTopicsDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeTopicsDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTopicsDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTopicsDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTopicsDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTopicsDetectionJobResult describeTopicsDetectionJobResult = (DescribeTopicsDetectionJobResult)response.getAwsResponse();
            return describeTopicsDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectDominantLanguageResult detectDominantLanguage(DetectDominantLanguageRequest request) {
        request = (DetectDominantLanguageRequest)this.beforeClientExecution(request);
        return this.executeDetectDominantLanguage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectDominantLanguageResult executeDetectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectDominantLanguageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectDominantLanguageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectDominantLanguageRequestProtocolMarshaller(protocolFactory).marshall((DetectDominantLanguageRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectDominantLanguageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectDominantLanguage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectDominantLanguageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectDominantLanguageResult detectDominantLanguageResult = (DetectDominantLanguageResult)response.getAwsResponse();
            return detectDominantLanguageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectEntitiesResult detectEntities(DetectEntitiesRequest request) {
        request = (DetectEntitiesRequest)this.beforeClientExecution(request);
        return this.executeDetectEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectEntitiesResult executeDetectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectEntitiesRequestProtocolMarshaller(protocolFactory).marshall((DetectEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectEntitiesResult detectEntitiesResult = (DetectEntitiesResult)response.getAwsResponse();
            return detectEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectKeyPhrasesResult detectKeyPhrases(DetectKeyPhrasesRequest request) {
        request = (DetectKeyPhrasesRequest)this.beforeClientExecution(request);
        return this.executeDetectKeyPhrases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectKeyPhrasesResult executeDetectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectKeyPhrasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectKeyPhrasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectKeyPhrasesRequestProtocolMarshaller(protocolFactory).marshall((DetectKeyPhrasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectKeyPhrasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectKeyPhrases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectKeyPhrasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectKeyPhrasesResult detectKeyPhrasesResult = (DetectKeyPhrasesResult)response.getAwsResponse();
            return detectKeyPhrasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectSentimentResult detectSentiment(DetectSentimentRequest request) {
        request = (DetectSentimentRequest)this.beforeClientExecution(request);
        return this.executeDetectSentiment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectSentimentResult executeDetectSentiment(DetectSentimentRequest detectSentimentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectSentimentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectSentimentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectSentimentRequestProtocolMarshaller(protocolFactory).marshall((DetectSentimentRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectSentimentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectSentiment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectSentimentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectSentimentResult detectSentimentResult = (DetectSentimentResult)response.getAwsResponse();
            return detectSentimentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectSyntaxResult detectSyntax(DetectSyntaxRequest request) {
        request = (DetectSyntaxRequest)this.beforeClientExecution(request);
        return this.executeDetectSyntax(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectSyntaxResult executeDetectSyntax(DetectSyntaxRequest detectSyntaxRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectSyntaxRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectSyntaxRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectSyntaxRequestProtocolMarshaller(protocolFactory).marshall((DetectSyntaxRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectSyntaxRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectSyntax");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectSyntaxResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectSyntaxResult detectSyntaxResult = (DetectSyntaxResult)response.getAwsResponse();
            return detectSyntaxResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDocumentClassificationJobsResult listDocumentClassificationJobs(ListDocumentClassificationJobsRequest request) {
        request = (ListDocumentClassificationJobsRequest)this.beforeClientExecution(request);
        return this.executeListDocumentClassificationJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDocumentClassificationJobsResult executeListDocumentClassificationJobs(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDocumentClassificationJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDocumentClassificationJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDocumentClassificationJobsRequestProtocolMarshaller(protocolFactory).marshall((ListDocumentClassificationJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDocumentClassificationJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDocumentClassificationJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDocumentClassificationJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDocumentClassificationJobsResult listDocumentClassificationJobsResult = (ListDocumentClassificationJobsResult)response.getAwsResponse();
            return listDocumentClassificationJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDocumentClassifiersResult listDocumentClassifiers(ListDocumentClassifiersRequest request) {
        request = (ListDocumentClassifiersRequest)this.beforeClientExecution(request);
        return this.executeListDocumentClassifiers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDocumentClassifiersResult executeListDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDocumentClassifiersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDocumentClassifiersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDocumentClassifiersRequestProtocolMarshaller(protocolFactory).marshall((ListDocumentClassifiersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDocumentClassifiersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDocumentClassifiers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDocumentClassifiersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDocumentClassifiersResult listDocumentClassifiersResult = (ListDocumentClassifiersResult)response.getAwsResponse();
            return listDocumentClassifiersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDominantLanguageDetectionJobsResult listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest request) {
        request = (ListDominantLanguageDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListDominantLanguageDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDominantLanguageDetectionJobsResult executeListDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDominantLanguageDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDominantLanguageDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDominantLanguageDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListDominantLanguageDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDominantLanguageDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDominantLanguageDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDominantLanguageDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDominantLanguageDetectionJobsResult listDominantLanguageDetectionJobsResult = (ListDominantLanguageDetectionJobsResult)response.getAwsResponse();
            return listDominantLanguageDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntitiesDetectionJobsResult listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest request) {
        request = (ListEntitiesDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListEntitiesDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntitiesDetectionJobsResult executeListEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntitiesDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntitiesDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntitiesDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListEntitiesDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEntitiesDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEntitiesDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEntitiesDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEntitiesDetectionJobsResult listEntitiesDetectionJobsResult = (ListEntitiesDetectionJobsResult)response.getAwsResponse();
            return listEntitiesDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntityRecognizersResult listEntityRecognizers(ListEntityRecognizersRequest request) {
        request = (ListEntityRecognizersRequest)this.beforeClientExecution(request);
        return this.executeListEntityRecognizers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntityRecognizersResult executeListEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntityRecognizersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntityRecognizersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntityRecognizersRequestProtocolMarshaller(protocolFactory).marshall((ListEntityRecognizersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEntityRecognizersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEntityRecognizers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEntityRecognizersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEntityRecognizersResult listEntityRecognizersResult = (ListEntityRecognizersResult)response.getAwsResponse();
            return listEntityRecognizersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListKeyPhrasesDetectionJobsResult listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest request) {
        request = (ListKeyPhrasesDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListKeyPhrasesDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListKeyPhrasesDetectionJobsResult executeListKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeyPhrasesDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeyPhrasesDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeyPhrasesDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListKeyPhrasesDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listKeyPhrasesDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListKeyPhrasesDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeyPhrasesDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListKeyPhrasesDetectionJobsResult listKeyPhrasesDetectionJobsResult = (ListKeyPhrasesDetectionJobsResult)response.getAwsResponse();
            return listKeyPhrasesDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSentimentDetectionJobsResult listSentimentDetectionJobs(ListSentimentDetectionJobsRequest request) {
        request = (ListSentimentDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListSentimentDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSentimentDetectionJobsResult executeListSentimentDetectionJobs(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSentimentDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSentimentDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSentimentDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListSentimentDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSentimentDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSentimentDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSentimentDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSentimentDetectionJobsResult listSentimentDetectionJobsResult = (ListSentimentDetectionJobsResult)response.getAwsResponse();
            return listSentimentDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTopicsDetectionJobsResult listTopicsDetectionJobs(ListTopicsDetectionJobsRequest request) {
        request = (ListTopicsDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListTopicsDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTopicsDetectionJobsResult executeListTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTopicsDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTopicsDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTopicsDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListTopicsDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTopicsDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTopicsDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTopicsDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTopicsDetectionJobsResult listTopicsDetectionJobsResult = (ListTopicsDetectionJobsResult)response.getAwsResponse();
            return listTopicsDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDocumentClassificationJobResult startDocumentClassificationJob(StartDocumentClassificationJobRequest request) {
        request = (StartDocumentClassificationJobRequest)this.beforeClientExecution(request);
        return this.executeStartDocumentClassificationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDocumentClassificationJobResult executeStartDocumentClassificationJob(StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDocumentClassificationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDocumentClassificationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDocumentClassificationJobRequestProtocolMarshaller(protocolFactory).marshall((StartDocumentClassificationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDocumentClassificationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDocumentClassificationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDocumentClassificationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDocumentClassificationJobResult startDocumentClassificationJobResult = (StartDocumentClassificationJobResult)response.getAwsResponse();
            return startDocumentClassificationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDominantLanguageDetectionJobResult startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest request) {
        request = (StartDominantLanguageDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartDominantLanguageDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDominantLanguageDetectionJobResult executeStartDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDominantLanguageDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDominantLanguageDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDominantLanguageDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartDominantLanguageDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDominantLanguageDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDominantLanguageDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDominantLanguageDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDominantLanguageDetectionJobResult startDominantLanguageDetectionJobResult = (StartDominantLanguageDetectionJobResult)response.getAwsResponse();
            return startDominantLanguageDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartEntitiesDetectionJobResult startEntitiesDetectionJob(StartEntitiesDetectionJobRequest request) {
        request = (StartEntitiesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartEntitiesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartEntitiesDetectionJobResult executeStartEntitiesDetectionJob(StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startEntitiesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartEntitiesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartEntitiesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartEntitiesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startEntitiesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartEntitiesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartEntitiesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartEntitiesDetectionJobResult startEntitiesDetectionJobResult = (StartEntitiesDetectionJobResult)response.getAwsResponse();
            return startEntitiesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartKeyPhrasesDetectionJobResult startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest request) {
        request = (StartKeyPhrasesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartKeyPhrasesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartKeyPhrasesDetectionJobResult executeStartKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startKeyPhrasesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartKeyPhrasesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartKeyPhrasesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartKeyPhrasesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startKeyPhrasesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartKeyPhrasesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartKeyPhrasesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartKeyPhrasesDetectionJobResult startKeyPhrasesDetectionJobResult = (StartKeyPhrasesDetectionJobResult)response.getAwsResponse();
            return startKeyPhrasesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSentimentDetectionJobResult startSentimentDetectionJob(StartSentimentDetectionJobRequest request) {
        request = (StartSentimentDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartSentimentDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSentimentDetectionJobResult executeStartSentimentDetectionJob(StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSentimentDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSentimentDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSentimentDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartSentimentDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSentimentDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSentimentDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSentimentDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSentimentDetectionJobResult startSentimentDetectionJobResult = (StartSentimentDetectionJobResult)response.getAwsResponse();
            return startSentimentDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTopicsDetectionJobResult startTopicsDetectionJob(StartTopicsDetectionJobRequest request) {
        request = (StartTopicsDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartTopicsDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTopicsDetectionJobResult executeStartTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTopicsDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTopicsDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTopicsDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartTopicsDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTopicsDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTopicsDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTopicsDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTopicsDetectionJobResult startTopicsDetectionJobResult = (StartTopicsDetectionJobResult)response.getAwsResponse();
            return startTopicsDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopDominantLanguageDetectionJobResult stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest request) {
        request = (StopDominantLanguageDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStopDominantLanguageDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopDominantLanguageDetectionJobResult executeStopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopDominantLanguageDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopDominantLanguageDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopDominantLanguageDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StopDominantLanguageDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopDominantLanguageDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopDominantLanguageDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopDominantLanguageDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopDominantLanguageDetectionJobResult stopDominantLanguageDetectionJobResult = (StopDominantLanguageDetectionJobResult)response.getAwsResponse();
            return stopDominantLanguageDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopEntitiesDetectionJobResult stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest request) {
        request = (StopEntitiesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStopEntitiesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopEntitiesDetectionJobResult executeStopEntitiesDetectionJob(StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopEntitiesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopEntitiesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopEntitiesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StopEntitiesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopEntitiesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopEntitiesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopEntitiesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopEntitiesDetectionJobResult stopEntitiesDetectionJobResult = (StopEntitiesDetectionJobResult)response.getAwsResponse();
            return stopEntitiesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopKeyPhrasesDetectionJobResult stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest request) {
        request = (StopKeyPhrasesDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStopKeyPhrasesDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopKeyPhrasesDetectionJobResult executeStopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopKeyPhrasesDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopKeyPhrasesDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopKeyPhrasesDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StopKeyPhrasesDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopKeyPhrasesDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopKeyPhrasesDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopKeyPhrasesDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopKeyPhrasesDetectionJobResult stopKeyPhrasesDetectionJobResult = (StopKeyPhrasesDetectionJobResult)response.getAwsResponse();
            return stopKeyPhrasesDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopSentimentDetectionJobResult stopSentimentDetectionJob(StopSentimentDetectionJobRequest request) {
        request = (StopSentimentDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStopSentimentDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopSentimentDetectionJobResult executeStopSentimentDetectionJob(StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopSentimentDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopSentimentDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopSentimentDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StopSentimentDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopSentimentDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopSentimentDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopSentimentDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopSentimentDetectionJobResult stopSentimentDetectionJobResult = (StopSentimentDetectionJobResult)response.getAwsResponse();
            return stopSentimentDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopTrainingDocumentClassifierResult stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest request) {
        request = (StopTrainingDocumentClassifierRequest)this.beforeClientExecution(request);
        return this.executeStopTrainingDocumentClassifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopTrainingDocumentClassifierResult executeStopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTrainingDocumentClassifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTrainingDocumentClassifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTrainingDocumentClassifierRequestProtocolMarshaller(protocolFactory).marshall((StopTrainingDocumentClassifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopTrainingDocumentClassifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopTrainingDocumentClassifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopTrainingDocumentClassifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopTrainingDocumentClassifierResult stopTrainingDocumentClassifierResult = (StopTrainingDocumentClassifierResult)response.getAwsResponse();
            return stopTrainingDocumentClassifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopTrainingEntityRecognizerResult stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest request) {
        request = (StopTrainingEntityRecognizerRequest)this.beforeClientExecution(request);
        return this.executeStopTrainingEntityRecognizer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopTrainingEntityRecognizerResult executeStopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTrainingEntityRecognizerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTrainingEntityRecognizerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTrainingEntityRecognizerRequestProtocolMarshaller(protocolFactory).marshall((StopTrainingEntityRecognizerRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopTrainingEntityRecognizerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopTrainingEntityRecognizer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopTrainingEntityRecognizerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopTrainingEntityRecognizerResult stopTrainingEntityRecognizerResult = (StopTrainingEntityRecognizerResult)response.getAwsResponse();
            return stopTrainingEntityRecognizerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Comprehend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

